/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionList;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.NoMatchingTransitionException;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionSet;
import org.springframework.webflow.ViewSelection;

public abstract class TransitionableState
extends State {
    private TransitionSet transitions = new TransitionSet();
    private ActionList exitActionList = new ActionList();

    protected TransitionableState() {
    }

    protected TransitionableState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public TransitionSet getTransitionSet() {
        return this.transitions;
    }

    public void addExitAction(Action action) {
        this.getExitActionList().add(action);
    }

    public ActionList getExitActionList() {
        return this.exitActionList;
    }

    public ViewSelection onEvent(Event event, FlowExecutionControlContext context) throws NoMatchingTransitionException {
        return this.getRequiredTransition(context).execute(this, context);
    }

    public Transition getRequiredTransition(RequestContext context) throws NoMatchingTransitionException {
        Transition transition = this.getTransitionSet().getTransition(context);
        if (transition == null) {
            throw new NoMatchingTransitionException(this, context.getLastEvent());
        }
        return transition;
    }

    public ViewSelection reenter(FlowExecutionControlContext context) {
        return this.enter(context);
    }

    public void exit(FlowExecutionControlContext context) {
        this.exitActionList.execute(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("transitions", (Object)this.transitions).append("exitActionList", (Object)this.exitActionList);
    }
}

