/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;

public class FormObjectAccessor {
    private static final String CURRENT_FORM_OBJECT_ATTRIBUTE = "currentFormObject";
    private static final String ERRORS_PREFIX = BindException.ERROR_KEY_PREFIX;
    private RequestContext context;
    static /* synthetic */ Class class$org$springframework$validation$Errors;

    public FormObjectAccessor(RequestContext context) {
        this.context = context;
    }

    public Object getCurrentFormObject() {
        Object formObject = this.getCurrentFormObject(ScopeType.REQUEST);
        if (formObject != null) {
            return formObject;
        }
        formObject = this.getCurrentFormObject(ScopeType.FLOW);
        if (formObject != null) {
            return formObject;
        }
        return this.getCurrentFormObject(ScopeType.CONVERSATION);
    }

    public Object getCurrentFormObject(ScopeType scope) {
        return this.getFormObject(FormObjectAccessor.getCurrentFormObjectName(), scope);
    }

    public Object getFormObject(String formObjectName, ScopeType scopeType) {
        return scopeType.getScope(this.context).get(formObjectName);
    }

    public Object getFormObject(String formObjectName, Class formObjectClass, ScopeType scopeType) {
        return scopeType.getScope(this.context).get(formObjectName, formObjectClass);
    }

    public void setFormObject(Object formObject, String formObjectName, ScopeType scopeType) {
        scopeType.getScope(this.context).put(formObjectName, formObject);
        this.setCurrentFormObject(formObject, scopeType);
    }

    public void setCurrentFormObject(Object formObject, ScopeType scopeType) {
        scopeType.getScope(this.context).put(FormObjectAccessor.getCurrentFormObjectName(), formObject);
    }

    public Errors getCurrentFormErrors() {
        Errors errors = this.getCurrentFormErrors(ScopeType.REQUEST);
        if (errors != null) {
            return errors;
        }
        errors = this.getCurrentFormErrors(ScopeType.FLOW);
        if (errors != null) {
            return errors;
        }
        return this.getCurrentFormErrors(ScopeType.CONVERSATION);
    }

    public Errors getCurrentFormErrors(ScopeType scopeType) {
        return this.getFormErrors(FormObjectAccessor.getCurrentFormObjectName(), scopeType);
    }

    public Errors getFormErrors(String formObjectName, ScopeType scopeType) {
        return (Errors)scopeType.getScope(this.context).get(ERRORS_PREFIX + formObjectName, class$org$springframework$validation$Errors == null ? (class$org$springframework$validation$Errors = FormObjectAccessor.class$("org.springframework.validation.Errors")) : class$org$springframework$validation$Errors);
    }

    public void setFormErrors(Errors errors, ScopeType scopeType) {
        scopeType.getScope(this.context).put(ERRORS_PREFIX + errors.getObjectName(), errors);
        this.setCurrentFormErrors(errors, scopeType);
    }

    public void setCurrentFormErrors(Errors errors, ScopeType scopeType) {
        scopeType.getScope(this.context).put(FormObjectAccessor.getCurrentFormErrorsName(), errors);
    }

    public static String getCurrentFormObjectName() {
        return CURRENT_FORM_OBJECT_ATTRIBUTE;
    }

    public static String getCurrentFormErrorsName() {
        return ERRORS_PREFIX + FormObjectAccessor.getCurrentFormObjectName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

