/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.UnmodifiableAttributeMap;

public class FlowArtifactParameters
implements Serializable {
    private String id;
    private UnmodifiableAttributeMap attributes;

    public FlowArtifactParameters(String id) {
        this(id, null);
    }

    public FlowArtifactParameters(String id, AttributeCollection attributes) {
        Assert.hasText((String)id, (String)"The id parameter is required");
        this.id = id;
        this.attributes = attributes == null ? CollectionUtils.EMPTY_ATTRIBUTE_MAP : attributes.unmodifiable();
    }

    public String getId() {
        return this.id;
    }

    public UnmodifiableAttributeMap getAttributes() {
        return this.attributes;
    }

    public FlowArtifactParameters putAll(AttributeCollection attributes) {
        if (attributes != null) {
            return new FlowArtifactParameters(this.getId(), new AttributeMap(this.getAttributes()).putAll(attributes));
        }
        return this;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("attributes", (Object)this.attributes).toString();
    }
}

