/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.method.MethodSignature;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionState;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.DecisionState;
import org.springframework.webflow.EndState;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowArtifactException;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.ScopeType;
import org.springframework.webflow.State;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.SubflowState;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.ViewState;
import org.springframework.webflow.action.FlowVariableCreatingAction;
import org.springframework.webflow.builder.BaseFlowBuilder;
import org.springframework.webflow.builder.DefaultFlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactParameters;
import org.springframework.webflow.builder.FlowBuilderException;
import org.springframework.webflow.builder.ResourceHolder;
import org.springframework.webflow.builder.WebFlowDtdResolver;
import org.springframework.webflow.support.CollectionAddingPropertyExpression;
import org.springframework.webflow.support.DefaultFlowAttributeMapper;
import org.springframework.webflow.support.FlowScopeExpression;
import org.springframework.webflow.support.FlowVariable;
import org.springframework.webflow.support.StaticTargetStateResolver;
import org.springframework.webflow.support.TransitionCriteriaChain;
import org.springframework.webflow.support.TransitionExecutingStateExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlFlowBuilder
extends BaseFlowBuilder
implements ResourceHolder {
    private static final String ID_ATTRIBUTE = "id";
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String FLOW_ELEMENT = "flow";
    private static final String START_STATE_ATTRIBUTE = "start-state";
    private static final String ACTION_STATE_ELEMENT = "action-state";
    private static final String ACTION_ELEMENT = "action";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String RESULT_NAME_ATTRIBUTE = "resultName";
    private static final String RESULT_SCOPE_ATTRIBUTE = "resultScope";
    private static final String DEFAULT_VALUE = "default";
    private static final String VIEW_STATE_ELEMENT = "view-state";
    private static final String VIEW_ATTRIBUTE = "view";
    private static final String DECISION_STATE_ELEMENT = "decision-state";
    private static final String IF_ELEMENT = "if";
    private static final String TEST_ATTRIBUTE = "test";
    private static final String THEN_ATTRIBUTE = "then";
    private static final String ELSE_ATTRIBUTE = "else";
    private static final String SUBFLOW_STATE_ELEMENT = "subflow-state";
    private static final String FLOW_ATTRIBUTE = "flow";
    private static final String ATTRIBUTE_MAPPER_ELEMENT = "attribute-mapper";
    private static final String INPUT_MAPPING_ELEMENT = "input-mapping";
    private static final String OUTPUT_MAPPING_ELEMENT = "output-mapping";
    private static final String AS_ATTRIBUTE = "as";
    private static final String COLLECTION_ATTRIBUTE = "collection";
    private static final String END_STATE_ELEMENT = "end-state";
    private static final String OUTPUT_ATTRIBUTE_ELEMENT = "output-attribute";
    private static final String TRANSITION_ELEMENT = "transition";
    private static final String GLOBAL_TRANSITIONS_ELEMENT = "global-transitions";
    private static final String ON_ATTRIBUTE = "on";
    private static final String TO_ATTRIBUTE = "to";
    private static final String FROM_ATTRIBUTE = "from";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String VALUE_ELEMENT = "value";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VAR_ELEMENT = "var";
    private static final String START_ACTIONS_ELEMENT = "start-actions";
    private static final String END_ACTIONS_ELEMENT = "end-actions";
    private static final String ENTRY_ACTIONS_ELEMENT = "entry-actions";
    private static final String EXIT_ACTIONS_ELEMENT = "exit-actions";
    private static final String EXCEPTION_HANDLER_ELEMENT = "exception-handler";
    private static final String INLINE_FLOW_ELEMENT = "inline-flow";
    private static final String IMPORT_ELEMENT = "import";
    private static final String RESOURCE_ATTRIBUTE = "resource";
    protected Resource location;
    private LocalFlowArtifactFactory localFlowArtifactFactory = new LocalFlowArtifactFactory();
    private boolean validating = true;
    private EntityResolver entityResolver = new WebFlowDtdResolver();
    private Document document;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$webflow$ActionState;
    static /* synthetic */ Class class$org$springframework$webflow$ViewState;
    static /* synthetic */ Class class$org$springframework$webflow$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$DecisionState;
    static /* synthetic */ Class class$org$springframework$webflow$SubflowState;
    static /* synthetic */ Class class$org$springframework$webflow$EndState;
    static /* synthetic */ Class class$org$springframework$binding$method$MethodSignature;
    static /* synthetic */ Class class$org$springframework$webflow$ScopeType;
    static /* synthetic */ Class class$org$springframework$webflow$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$Action;
    static /* synthetic */ Class class$org$springframework$webflow$FlowAttributeMapper;
    static /* synthetic */ Class class$org$springframework$webflow$StateExceptionHandler;

    public XmlFlowBuilder(Resource location) {
        this.setLocation(location);
    }

    public XmlFlowBuilder(Resource location, FlowArtifactFactory flowArtifactFactory) {
        super(flowArtifactFactory);
        this.setLocation(location);
    }

    public Resource getLocation() {
        return this.location;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public Resource getResource() {
        return this.location;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void init(FlowArtifactParameters flowParameters) throws FlowBuilderException {
        Assert.notNull((Object)this.getLocation(), (String)"The location property specifying the XML flow definition resource location is required");
        try {
            this.document = this.loadDocument();
            Assert.notNull((Object)this.document, (String)"Document should never be null");
        }
        catch (IOException e) {
            throw new FlowBuilderException(this, "Could not load the XML flow definition resource at '" + this.getLocation() + "'", e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowBuilderException(this, "Could not configure the parser to parse the XML flow definition", e);
        }
        catch (SAXException e) {
            throw new FlowBuilderException(this, "Could not parse the flow definition XML document at '" + this.getLocation() + "'", e);
        }
        this.setFlow(this.parseFlow(flowParameters, this.getDocumentElement()));
        this.addInlineFlowDefinitions(this.getFlow(), this.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDocument() throws IOException, ParserConfigurationException, SAXException {
        InputStream is = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.isValidating());
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler((ErrorHandler)new SimpleSaxErrorHandler(this.logger));
            docBuilder.setEntityResolver(this.getEntityResolver());
            is = this.getLocation().getInputStream();
            Document document = docBuilder.parse(is);
            return document;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.logger.warn((Object)"Could not close InputStream", (Throwable)ex);
                }
            }
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    protected FlowArtifactFactory getLocalFlowArtifactFactory() {
        return this.localFlowArtifactFactory;
    }

    protected Flow parseFlow(FlowArtifactParameters flowParameters, Element flowElement) {
        Assert.state((boolean)"flow".equals(flowElement.getTagName()), (String)"This is not the 'flow' element");
        this.initLocalFlowArtifactFactoryRegistry(flowElement);
        FlowArtifactParameters parameters = flowParameters.putAll(this.parseAttributes(flowElement));
        Flow flow = this.getLocalFlowArtifactFactory().createFlow(parameters);
        this.parseAndAddFlowVariables(flowElement, flow);
        this.parseAndAddFlowActions(flowElement, flow);
        this.parseAndAddFlowTransitions(flowElement, flow);
        return flow;
    }

    protected void initLocalFlowArtifactFactoryRegistry(Element flowElement) {
        List importElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)IMPORT_ELEMENT);
        Resource[] resources = new Resource[importElements.size()];
        for (int i = 0; i < importElements.size(); ++i) {
            Element importElement = (Element)importElements.get(i);
            try {
                resources[i] = this.getLocation().createRelative(importElement.getAttribute(RESOURCE_ATTRIBUTE));
                continue;
            }
            catch (IOException e) {
                throw new FlowBuilderException(this, "Could not access flow-relative artifact resource '" + importElement.getAttribute(RESOURCE_ATTRIBUTE) + "'", e);
            }
        }
        GenericApplicationContext context = new GenericApplicationContext();
        context.setResourceLoader(this.getFlowArtifactFactory().getResourceLoader());
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)context).loadBeanDefinitions(resources);
        this.localFlowArtifactFactory.push(new LocalFlowArtifactRegistry((ConfigurableApplicationContext)context));
    }

    protected void parseAndAddFlowVariables(Element flowElement, Flow flow) {
        List varElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)VAR_ELEMENT);
        if (varElements.isEmpty()) {
            return;
        }
        FlowVariableCreatingAction variableCreator = new FlowVariableCreatingAction();
        for (int i = 0; i < varElements.size(); ++i) {
            variableCreator.addVariable(this.parseVariable((Element)varElements.get(i)));
        }
        flow.addStartAction(variableCreator);
    }

    protected FlowVariable parseVariable(Element element) {
        Class type = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(TYPE_ATTRIBUTE));
        return new FlowVariable(element.getAttribute(NAME_ATTRIBUTE), type);
    }

    protected void parseAndAddFlowActions(Element element, Flow flow) {
        List endElements;
        List startElements = DomUtils.getChildElementsByTagName((Element)element, (String)START_ACTIONS_ELEMENT);
        if (!startElements.isEmpty()) {
            Element startElement = (Element)startElements.get(0);
            flow.getStartActionList().addAll(this.parseAnnotatedActions(startElement));
        }
        if (!(endElements = DomUtils.getChildElementsByTagName((Element)element, (String)END_ACTIONS_ELEMENT)).isEmpty()) {
            Element endElement = (Element)endElements.get(0);
            flow.getEndActionList().addAll(this.parseAnnotatedActions(endElement));
        }
    }

    protected void parseAndAddFlowTransitions(Element element, Flow flow) {
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)GLOBAL_TRANSITIONS_ELEMENT);
        if (!transitionElements.isEmpty()) {
            Element transitionElement = (Element)transitionElements.get(0);
            flow.getGlobalTransitionSet().addAll(this.parseTransitions(transitionElement));
        }
    }

    protected void addInlineFlowDefinitions(Flow flow, Element parentFlowElement) {
        List inlineFlowElements = DomUtils.getChildElementsByTagName((Element)parentFlowElement, (String)INLINE_FLOW_ELEMENT);
        if (inlineFlowElements.isEmpty()) {
            return;
        }
        for (int i = 0; i < inlineFlowElements.size(); ++i) {
            Element inlineFlowElement = (Element)inlineFlowElements.get(i);
            String inlineFlowId = inlineFlowElement.getAttribute(ID_ATTRIBUTE);
            Element flowElement = (Element)inlineFlowElement.getElementsByTagName("flow").item(0);
            Flow inlineFlow = this.parseFlow(new FlowArtifactParameters(inlineFlowId), flowElement);
            this.buildInlineFlow(inlineFlow, flowElement);
            flow.addInlineFlow(inlineFlow);
        }
    }

    protected void buildInlineFlow(Flow inlineFlow, Element flowElement) {
        this.addInlineFlowDefinitions(inlineFlow, flowElement);
        this.addStateDefinitions(inlineFlow, flowElement);
        inlineFlow.getExceptionHandlerSet().addAll(this.parseExceptionHandlers(flowElement));
        this.destroyFlowArtifactRegistry(inlineFlow);
    }

    public void buildStates() throws FlowBuilderException {
        this.addStateDefinitions(this.getFlow(), this.getDocumentElement());
    }

    protected void addStateDefinitions(Flow flow, Element flowElement) {
        String startStateId = flowElement.getAttribute(START_STATE_ATTRIBUTE);
        NodeList nodeList = flowElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            State state = null;
            if (ACTION_STATE_ELEMENT.equals(childElement.getNodeName())) {
                state = this.parseActionState(flow, childElement);
            } else if (VIEW_STATE_ELEMENT.equals(childElement.getNodeName())) {
                state = this.parseViewState(flow, childElement);
            } else if (DECISION_STATE_ELEMENT.equals(childElement.getNodeName())) {
                state = this.parseDecisionState(flow, childElement);
            } else if (SUBFLOW_STATE_ELEMENT.equals(childElement.getNodeName())) {
                state = this.parseSubflowState(flow, childElement);
            } else if (END_STATE_ELEMENT.equals(childElement.getNodeName())) {
                state = this.parseEndState(flow, childElement);
            }
            if (state == null) continue;
            this.parseAndAddStateActions(childElement, state);
            state.getExceptionHandlerSet().addAll(this.parseExceptionHandlers(childElement));
        }
        flow.setStartState(startStateId);
    }

    protected void parseAndAddStateActions(Element element, State state) {
        List exitElements;
        List entryElements = DomUtils.getChildElementsByTagName((Element)element, (String)ENTRY_ACTIONS_ELEMENT);
        if (!entryElements.isEmpty()) {
            Element entryElement = (Element)entryElements.get(0);
            state.getEntryActionList().addAll(this.parseAnnotatedActions(entryElement));
        }
        if (state instanceof TransitionableState && !(exitElements = DomUtils.getChildElementsByTagName((Element)element, (String)EXIT_ACTIONS_ELEMENT)).isEmpty()) {
            Element exitElement = (Element)exitElements.get(0);
            ((TransitionableState)state).getExitActionList().addAll(this.parseAnnotatedActions(exitElement));
        }
    }

    protected ActionState parseActionState(Flow flow, Element element) {
        ActionState state = (ActionState)this.getLocalFlowArtifactFactory().createState(flow, class$org$springframework$webflow$ActionState == null ? (class$org$springframework$webflow$ActionState = XmlFlowBuilder.class$("org.springframework.webflow.ActionState")) : class$org$springframework$webflow$ActionState, this.parseParameters(element));
        state.getActionList().addAll(this.parseAnnotatedActions(element));
        state.getTransitionSet().addAll(this.parseTransitions(element));
        return state;
    }

    protected ViewState parseViewState(Flow flow, Element element) {
        ViewState state = (ViewState)this.getLocalFlowArtifactFactory().createState(flow, class$org$springframework$webflow$ViewState == null ? (class$org$springframework$webflow$ViewState = XmlFlowBuilder.class$("org.springframework.webflow.ViewState")) : class$org$springframework$webflow$ViewState, this.parseParameters(element));
        if (element.hasAttribute(VIEW_ATTRIBUTE)) {
            state.setViewSelector((ViewSelector)this.fromStringTo(class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = XmlFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector).execute((Object)element.getAttribute(VIEW_ATTRIBUTE)));
        }
        state.getTransitionSet().addAll(this.parseTransitions(element));
        return state;
    }

    protected FlowArtifactParameters parseParameters(Element element) {
        return new FlowArtifactParameters(element.getAttribute(ID_ATTRIBUTE), this.parseAttributes(element));
    }

    protected DecisionState parseDecisionState(Flow flow, Element element) {
        DecisionState state = (DecisionState)this.getLocalFlowArtifactFactory().createState(flow, class$org$springframework$webflow$DecisionState == null ? (class$org$springframework$webflow$DecisionState = XmlFlowBuilder.class$("org.springframework.webflow.DecisionState")) : class$org$springframework$webflow$DecisionState, this.parseParameters(element));
        state.getTransitionSet().addAll(this.parseIfs(element));
        state.getTransitionSet().addAll(this.parseTransitions(element));
        List actionElements = DomUtils.getChildElementsByTagName((Element)element, (String)ACTION_ELEMENT);
        if (!actionElements.isEmpty()) {
            Element actionElement = (Element)actionElements.get(0);
            state.setAction(this.parseAnnotatedAction(actionElement));
        }
        return state;
    }

    protected SubflowState parseSubflowState(Flow flow, Element element) {
        SubflowState state = (SubflowState)this.getLocalFlowArtifactFactory().createState(flow, class$org$springframework$webflow$SubflowState == null ? (class$org$springframework$webflow$SubflowState = XmlFlowBuilder.class$("org.springframework.webflow.SubflowState")) : class$org$springframework$webflow$SubflowState, this.parseParameters(element));
        state.setSubflow(this.getLocalFlowArtifactFactory().getSubflow(element.getAttribute("flow")));
        state.setAttributeMapper(this.parseAttributeMapper(element));
        state.getTransitionSet().addAll(this.parseTransitions(element));
        return state;
    }

    protected EndState parseEndState(Flow flow, Element element) {
        EndState state = (EndState)this.getLocalFlowArtifactFactory().createState(flow, class$org$springframework$webflow$EndState == null ? (class$org$springframework$webflow$EndState = XmlFlowBuilder.class$("org.springframework.webflow.EndState")) : class$org$springframework$webflow$EndState, this.parseParameters(element));
        if (element.hasAttribute(VIEW_ATTRIBUTE)) {
            state.setViewSelector((ViewSelector)this.fromStringTo(class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = XmlFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector).execute((Object)element.getAttribute(VIEW_ATTRIBUTE)));
        }
        List outputAttributeElements = DomUtils.getChildElementsByTagName((Element)element, (String)OUTPUT_ATTRIBUTE_ELEMENT);
        Iterator it = outputAttributeElements.iterator();
        while (it.hasNext()) {
            Element outputElement = (Element)it.next();
            state.addOutputAttributeName(outputElement.getAttribute(NAME_ATTRIBUTE));
        }
        return state;
    }

    protected AnnotatedAction[] parseAnnotatedActions(Element element) {
        LinkedList<AnnotatedAction> actions = new LinkedList<AnnotatedAction>();
        List actionElements = DomUtils.getChildElementsByTagName((Element)element, (String)ACTION_ELEMENT);
        Iterator it = actionElements.iterator();
        while (it.hasNext()) {
            actions.add(this.parseAnnotatedAction((Element)it.next()));
        }
        return actions.toArray(new AnnotatedAction[0]);
    }

    protected AnnotatedAction parseAnnotatedAction(Element element) {
        AnnotatedAction action = new AnnotatedAction();
        if (element.hasAttribute(NAME_ATTRIBUTE)) {
            action.setName(element.getAttribute(NAME_ATTRIBUTE));
        }
        if (element.hasAttribute(METHOD_ATTRIBUTE)) {
            MethodSignature method = (MethodSignature)this.fromStringTo(class$org$springframework$binding$method$MethodSignature == null ? (class$org$springframework$binding$method$MethodSignature = XmlFlowBuilder.class$("org.springframework.binding.method.MethodSignature")) : class$org$springframework$binding$method$MethodSignature).execute((Object)element.getAttribute(METHOD_ATTRIBUTE));
            action.setMethod(method);
        }
        if (element.hasAttribute(RESULT_NAME_ATTRIBUTE)) {
            action.setResultName(element.getAttribute(RESULT_NAME_ATTRIBUTE));
        }
        if (element.hasAttribute(RESULT_SCOPE_ATTRIBUTE) && !element.getAttribute(RESULT_SCOPE_ATTRIBUTE).equals(DEFAULT_VALUE)) {
            ScopeType scopeType = (ScopeType)((Object)this.fromStringTo(class$org$springframework$webflow$ScopeType == null ? (class$org$springframework$webflow$ScopeType = XmlFlowBuilder.class$("org.springframework.webflow.ScopeType")) : class$org$springframework$webflow$ScopeType).execute((Object)element.getAttribute(RESULT_SCOPE_ATTRIBUTE)));
            action.setResultScope(scopeType);
        }
        action.getAttributeMap().putAll(this.parseAttributes(element));
        action.setTargetAction(this.parseAction(element, action.getAttributeMap()));
        return action;
    }

    protected Action parseAction(Element element, AttributeMap attributes) {
        String actionId = element.getAttribute(BEAN_ATTRIBUTE);
        FlowArtifactParameters actionParameters = new FlowArtifactParameters(actionId, attributes);
        return this.getLocalFlowArtifactFactory().getAction(actionParameters);
    }

    protected AttributeCollection parseAttributes(Element element) {
        AttributeMap attributes = new AttributeMap();
        List propertyElements = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTE_ELEMENT);
        for (int i = 0; i < propertyElements.size(); ++i) {
            this.parseAndSetAttribute((Element)propertyElements.get(i), attributes);
        }
        return attributes;
    }

    protected void parseAndSetAttribute(Element element, AttributeMap attributes) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        String value = null;
        if (element.hasAttribute("value")) {
            value = element.getAttribute("value");
        } else {
            List valueElements = DomUtils.getChildElementsByTagName((Element)element, (String)"value");
            Assert.state((valueElements.size() == 1 ? 1 : 0) != 0, (String)("A property value should be specified for property '" + name + "'"));
            value = DomUtils.getTextValue((Element)((Element)valueElements.get(0)));
        }
        attributes.put(name, this.convertPropertyValue(element, value));
    }

    protected Object convertPropertyValue(Element element, String stringValue) {
        if (element.hasAttribute(TYPE_ATTRIBUTE)) {
            ConversionExecutor executor = this.fromStringToAliased(element.getAttribute(TYPE_ATTRIBUTE));
            if (executor != null) {
                return executor.execute((Object)stringValue);
            }
            Class targetClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(TYPE_ATTRIBUTE));
            return this.fromStringTo(targetClass).execute((Object)stringValue);
        }
        return stringValue;
    }

    protected Transition[] parseTransitions(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)TRANSITION_ELEMENT);
        for (int i = 0; i < transitionElements.size(); ++i) {
            transitions.add(this.parseTransition((Element)transitionElements.get(i)));
        }
        return transitions.toArray(new Transition[0]);
    }

    protected Transition parseTransition(Element element) {
        Transition transition = this.getLocalFlowArtifactFactory().createTransition(this.parseAttributes(element).unmodifiable());
        transition.setMatchingCriteria((TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)element.getAttribute(ON_ATTRIBUTE)));
        transition.setExecutionCriteria(TransitionCriteriaChain.criteriaChainFor(this.parseAnnotatedActions(element)));
        transition.setTargetStateResolver((TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver).execute((Object)element.getAttribute(TO_ATTRIBUTE)));
        return transition;
    }

    protected Transition[] parseIfs(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)IF_ELEMENT);
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            transitions.addAll(Arrays.asList(this.parseIf((Element)it.next())));
        }
        return transitions.toArray(new Transition[0]);
    }

    protected Transition[] parseIf(Element element) {
        TransitionCriteria criteria = (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria).execute((Object)element.getAttribute(TEST_ATTRIBUTE));
        Transition thenTransition = this.getLocalFlowArtifactFactory().createTransition(CollectionUtils.EMPTY_ATTRIBUTE_MAP);
        thenTransition.setMatchingCriteria(criteria);
        thenTransition.setTargetStateResolver(new StaticTargetStateResolver(element.getAttribute(THEN_ATTRIBUTE)));
        if (StringUtils.hasText((String)element.getAttribute(ELSE_ATTRIBUTE))) {
            Transition elseTransition = this.getLocalFlowArtifactFactory().createTransition(CollectionUtils.EMPTY_ATTRIBUTE_MAP);
            elseTransition.setTargetStateResolver(new StaticTargetStateResolver(element.getAttribute(ELSE_ATTRIBUTE)));
            return new Transition[]{thenTransition, elseTransition};
        }
        return new Transition[]{thenTransition};
    }

    protected FlowAttributeMapper parseAttributeMapper(Element element) {
        List mapperElements = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTE_MAPPER_ELEMENT);
        if (mapperElements.isEmpty()) {
            return null;
        }
        Element mapperElement = (Element)mapperElements.get(0);
        if (mapperElement.hasAttribute(BEAN_ATTRIBUTE)) {
            return this.getLocalFlowArtifactFactory().getAttributeMapper(mapperElement.getAttribute(BEAN_ATTRIBUTE));
        }
        DefaultFlowAttributeMapper attributeMapper = new DefaultFlowAttributeMapper();
        List inputElements = DomUtils.getChildElementsByTagName((Element)mapperElement, (String)INPUT_MAPPING_ELEMENT);
        ArrayList inputMappings = new ArrayList(inputElements.size());
        Iterator it = inputElements.iterator();
        while (it.hasNext()) {
            this.parseAndAddInputMapping((Element)it.next(), inputMappings);
        }
        attributeMapper.addInputMappings(inputMappings.toArray(new Mapping[inputMappings.size()]));
        List outputElements = DomUtils.getChildElementsByTagName((Element)mapperElement, (String)OUTPUT_MAPPING_ELEMENT);
        ArrayList outputMappings = new ArrayList(outputElements.size());
        Iterator it2 = outputElements.iterator();
        while (it2.hasNext()) {
            this.parseAndAddOutputMapping((Element)it2.next(), outputMappings);
        }
        attributeMapper.addOutputMappings(outputMappings.toArray(new Mapping[outputMappings.size()]));
        return attributeMapper;
    }

    protected void parseAndAddInputMapping(Element element, List inputMappings) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        String value = element.getAttribute("value");
        String as = element.getAttribute(AS_ATTRIBUTE);
        ConversionExecutor typeConverter = this.parseTypeConverter(element);
        ExpressionParser parser = this.getExpressionParser();
        if (StringUtils.hasText((String)name)) {
            Assert.isTrue((!StringUtils.hasText((String)value) ? 1 : 0) != 0, (String)"The 'name' attribute cannot be used with the 'value' attribute -- use one or the other");
            if (StringUtils.hasText((String)as)) {
                inputMappings.add(new Mapping((Expression)new FlowScopeExpression(parser.parseExpression(name)), parser.parsePropertyExpression(as), typeConverter));
            } else {
                inputMappings.add(new Mapping((Expression)new FlowScopeExpression(parser.parseExpression(name)), this.getExpressionParser().parsePropertyExpression(name), typeConverter));
            }
        } else if (StringUtils.hasText((String)value)) {
            Assert.hasText((String)as, (String)"The 'as' attribute is required with the 'value' attribute");
            inputMappings.add(new Mapping(this.getExpressionParser().parseExpression(value), this.getExpressionParser().parsePropertyExpression(as), typeConverter));
        } else {
            throw new FlowBuilderException(this, "Use of the 'name' or 'value' attribute is required in input mapping definition " + element);
        }
    }

    protected void parseAndAddOutputMapping(Element element, List outputMappings) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        String as = element.getAttribute(AS_ATTRIBUTE);
        String collection = element.getAttribute(COLLECTION_ATTRIBUTE);
        ConversionExecutor typeConverter = this.parseTypeConverter(element);
        ExpressionParser parser = this.getExpressionParser();
        if (StringUtils.hasText((String)as)) {
            outputMappings.add(new Mapping(parser.parseExpression(name), parser.parsePropertyExpression(as), typeConverter));
        } else if (StringUtils.hasText((String)collection)) {
            CollectionAddingPropertyExpression collectionExpression = new CollectionAddingPropertyExpression(new FlowScopeExpression(parser.parseExpression(collection)));
            outputMappings.add(new Mapping(parser.parseExpression(name), (PropertyExpression)collectionExpression, typeConverter));
        } else {
            outputMappings.add(new Mapping(parser.parseExpression(name), parser.parsePropertyExpression(name), typeConverter));
        }
    }

    protected ConversionExecutor parseTypeConverter(Element element) {
        String from = element.getAttribute(FROM_ATTRIBUTE);
        String to = element.getAttribute(TO_ATTRIBUTE);
        if (StringUtils.hasText((String)from)) {
            if (StringUtils.hasText((String)to)) {
                ConversionService service = this.getFlowArtifactFactory().getConversionService();
                return service.getConversionExecutor(service.getClassByAlias(from), service.getClassByAlias(to));
            }
            throw new IllegalArgumentException("Use of the 'from' attribute requires use of the 'to' attribute");
        }
        Assert.isTrue((!StringUtils.hasText((String)to) ? 1 : 0) != 0, (String)"Use of the 'to' attribute requires use of the 'from' attribute");
        return null;
    }

    public void buildExceptionHandlers() throws FlowBuilderException {
        this.getFlow().getExceptionHandlerSet().addAll(this.parseExceptionHandlers(this.getDocumentElement()));
    }

    protected StateExceptionHandler[] parseExceptionHandlers(Element element) {
        List handlerElements = DomUtils.getChildElementsByTagName((Element)element, (String)EXCEPTION_HANDLER_ELEMENT);
        if (handlerElements.isEmpty()) {
            return null;
        }
        StateExceptionHandler[] exceptionHandlers = new StateExceptionHandler[handlerElements.size()];
        for (int i = 0; i < handlerElements.size(); ++i) {
            Element handlerElement = (Element)handlerElements.get(i);
            exceptionHandlers[i] = handlerElement.hasAttribute(BEAN_ATTRIBUTE) ? this.getLocalFlowArtifactFactory().getExceptionHandler(handlerElement.getAttribute(BEAN_ATTRIBUTE)) : this.parseDefaultExceptionHandler(handlerElement);
        }
        return exceptionHandlers;
    }

    protected StateExceptionHandler parseDefaultExceptionHandler(Element element) {
        TransitionExecutingStateExceptionHandler defaultHandler = new TransitionExecutingStateExceptionHandler();
        Class exceptionClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(ON_ATTRIBUTE));
        defaultHandler.add(exceptionClass, element.getAttribute(TO_ATTRIBUTE));
        return defaultHandler;
    }

    public void dispose() {
        this.destroyFlowArtifactRegistry(this.getFlow());
        this.document = null;
    }

    protected void destroyFlowArtifactRegistry(Flow flow) {
        this.localFlowArtifactFactory.pop();
    }

    private ExpressionParser getExpressionParser() {
        return this.getFlowArtifactFactory().getExpressionParser();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalFlowArtifactRegistry {
        private Flow flow;
        private ConfigurableApplicationContext context;

        public LocalFlowArtifactRegistry(ConfigurableApplicationContext registry) {
            this.context = registry;
        }
    }

    private class LocalFlowArtifactFactory
    extends DefaultFlowArtifactFactory {
        private Stack localFlowArtifactRegistries = new Stack();

        private LocalFlowArtifactFactory() {
        }

        public void push(LocalFlowArtifactRegistry registry) {
            if (this.localFlowArtifactRegistries.isEmpty()) {
                this.attachRootServiceRegistryIfSupported(registry.context);
            } else {
                registry.context.setParent((ApplicationContext)this.top().context);
            }
            this.localFlowArtifactRegistries.push(registry);
        }

        protected void attachRootServiceRegistryIfSupported(ConfigurableApplicationContext context) {
            try {
                context.getBeanFactory().setParentBeanFactory(XmlFlowBuilder.this.getFlowArtifactFactory().getServiceRegistry());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        public LocalFlowArtifactRegistry pop() {
            return (LocalFlowArtifactRegistry)this.localFlowArtifactRegistries.pop();
        }

        public LocalFlowArtifactRegistry top() {
            return (LocalFlowArtifactRegistry)this.localFlowArtifactRegistries.peek();
        }

        public Flow getCurrentFlow() {
            return this.top().flow;
        }

        public Flow getSubflow(String id) throws FlowArtifactException {
            Flow currentFlow = this.getCurrentFlow();
            if (currentFlow.getId().equals(id)) {
                return currentFlow;
            }
            if (currentFlow.containsInlineFlow(id)) {
                return currentFlow.getInlineFlow(id);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getSubflow(id);
        }

        public Action getAction(FlowArtifactParameters parameters) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(parameters.getId())) {
                return this.toAction(this.getBean(parameters.getId(), class$org$springframework$webflow$Action == null ? (class$org$springframework$webflow$Action = XmlFlowBuilder.class$("org.springframework.webflow.Action")) : class$org$springframework$webflow$Action, false), parameters);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getAction(parameters);
        }

        public FlowAttributeMapper getAttributeMapper(String id) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(id)) {
                return (FlowAttributeMapper)this.getBean(id, class$org$springframework$webflow$FlowAttributeMapper == null ? (class$org$springframework$webflow$FlowAttributeMapper = XmlFlowBuilder.class$("org.springframework.webflow.FlowAttributeMapper")) : class$org$springframework$webflow$FlowAttributeMapper, true);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getAttributeMapper(id);
        }

        public StateExceptionHandler getExceptionHandler(String id) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(id)) {
                return (StateExceptionHandler)this.getBean(id, class$org$springframework$webflow$StateExceptionHandler == null ? (class$org$springframework$webflow$StateExceptionHandler = XmlFlowBuilder.class$("org.springframework.webflow.StateExceptionHandler")) : class$org$springframework$webflow$StateExceptionHandler, true);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getExceptionHandler(id);
        }

        public TransitionCriteria getTransitionCriteria(String id) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(id)) {
                return (TransitionCriteria)this.getBean(id, class$org$springframework$webflow$TransitionCriteria == null ? (class$org$springframework$webflow$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.TransitionCriteria")) : class$org$springframework$webflow$TransitionCriteria, true);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getTransitionCriteria(id);
        }

        public ViewSelector getViewSelector(String id) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(id)) {
                return (ViewSelector)this.getBean(id, class$org$springframework$webflow$ViewSelector == null ? (class$org$springframework$webflow$ViewSelector = XmlFlowBuilder.class$("org.springframework.webflow.ViewSelector")) : class$org$springframework$webflow$ViewSelector, true);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getViewSelector(id);
        }

        public TargetStateResolver getTargetStateResolver(String id) throws FlowArtifactException {
            if (!this.localFlowArtifactRegistries.isEmpty() && this.containsBean(id)) {
                return (TargetStateResolver)this.getBean(id, class$org$springframework$webflow$TargetStateResolver == null ? (class$org$springframework$webflow$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.TargetStateResolver")) : class$org$springframework$webflow$TargetStateResolver, true);
            }
            return XmlFlowBuilder.this.getFlowArtifactFactory().getTargetStateResolver(id);
        }

        public Flow createFlow(FlowArtifactParameters parameters) throws FlowArtifactException {
            this.top().flow = XmlFlowBuilder.this.getFlowArtifactFactory().createFlow(parameters);
            return this.top().flow;
        }

        public State createState(Flow flow, Class stateType, FlowArtifactParameters parameters) throws FlowArtifactException {
            return XmlFlowBuilder.this.getFlowArtifactFactory().createState(flow, stateType, parameters);
        }

        public Transition createTransition(UnmodifiableAttributeMap attributes) throws FlowArtifactException {
            return XmlFlowBuilder.this.getFlowArtifactFactory().createTransition(attributes);
        }

        protected boolean containsBean(String id) {
            return this.top().context.containsBean(id);
        }

        protected Object getBean(String id, Class type, boolean enforceTypeCheck) {
            try {
                if (enforceTypeCheck) {
                    return this.top().context.getBean(id, type);
                }
                return this.top().context.getBean(id);
            }
            catch (BeansException e) {
                throw new FlowArtifactException(id, type, e);
            }
        }
    }
}

