/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.webflow.context.StringKeyedMapAdapter;

public class HttpServletRequestParameterMap
extends StringKeyedMapAdapter {
    private HttpServletRequest request;

    public HttpServletRequestParameterMap(HttpServletRequest request) {
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartHttpServletRequest multipartRequest;
        Object data;
        if (this.request instanceof MultipartHttpServletRequest && (data = (multipartRequest = (MultipartHttpServletRequest)this.request).getFileMap().get(key)) != null) {
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected Enumeration getAttributeNames() {
        Enumeration parameterNames = this.request.getParameterNames();
        if (this.request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)this.request;
            return new MultiPartEnumeration(multipartRequest.getFileMap().keySet().iterator(), parameterNames);
        }
        return parameterNames;
    }

    private static class MultiPartEnumeration
    implements Enumeration {
        private Iterator fileMapNames;
        private Enumeration parameterNames;

        public MultiPartEnumeration(Iterator fileMapNames, Enumeration parameterNames) {
            this.fileMapNames = fileMapNames;
            this.parameterNames = parameterNames;
        }

        public boolean hasMoreElements() {
            return this.fileMapNames.hasNext() || this.parameterNames.hasMoreElements();
        }

        public Object nextElement() {
            if (this.fileMapNames.hasNext()) {
                return this.fileMapNames.next();
            }
            return this.parameterNames.nextElement();
        }
    }
}

