/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionListenerCriteria;
import org.springframework.webflow.execution.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.TextToFlowExecutionListenerCriteria;

public class ConditionalFlowExecutionListenerLoader
implements FlowExecutionListenerLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List listeners = new LinkedList();

    public void setListener(FlowExecutionListener listener) {
        this.setListeners(new FlowExecutionListener[]{listener});
    }

    public void setListeners(FlowExecutionListener[] listeners) {
        this.setListenersCriteria(listeners, FlowExecutionListenerCriteriaFactory.allFlows());
    }

    public void setListenerMap(Map listenerCriteriaMap) {
        Iterator it = listenerCriteriaMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowExecutionListenerCriteria criteria = entry.getValue() instanceof FlowExecutionListenerCriteria ? (FlowExecutionListenerCriteria)entry.getValue() : this.convertEncodedListenerCriteria((String)entry.getValue());
            if (entry.getKey() instanceof Collection) {
                Collection collection = (Collection)entry.getKey();
                FlowExecutionListener[] listeners = collection.toArray(new FlowExecutionListener[collection.size()]);
                this.setListenersCriteria(listeners, criteria);
                continue;
            }
            this.setListenerCriteria((FlowExecutionListener)entry.getKey(), criteria);
        }
    }

    public void addListener(FlowExecutionListener listener) {
        this.addListener(listener, FlowExecutionListenerCriteriaFactory.allFlows());
    }

    public void addListener(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        ConditionalFlowExecutionListenerHolder conditional;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding flow execution listener " + listener + " with criteria " + criteria));
        }
        if ((conditional = this.getHolder(listener)) == null) {
            conditional = new ConditionalFlowExecutionListenerHolder(listener);
            this.listeners.add(conditional);
        }
        if (criteria == null) {
            criteria = FlowExecutionListenerCriteriaFactory.allFlows();
        }
        conditional.add(criteria);
    }

    public FlowExecutionListener[] getListeners(Flow flow) {
        Assert.notNull((Object)flow, (String)"The Flow to load listeners for cannot be null");
        LinkedList<FlowExecutionListener> listenersToAttach = new LinkedList<FlowExecutionListener>();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder listenerHolder = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!listenerHolder.listenerAppliesTo(flow)) continue;
            listenersToAttach.add(listenerHolder.getListener());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded [" + listenersToAttach.size() + "] of possible " + this.listeners.size() + " listeners to this execution request for flow '" + flow.getId() + "', the listeners to attach are " + StylerUtils.style(listenersToAttach)));
        }
        return listenersToAttach.toArray(new FlowExecutionListener[listenersToAttach.size()]);
    }

    protected ConditionalFlowExecutionListenerHolder getHolder(FlowExecutionListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ConditionalFlowExecutionListenerHolder next = (ConditionalFlowExecutionListenerHolder)it.next();
            if (!next.getListener().equals(listener)) continue;
            return next;
        }
        return null;
    }

    public boolean containsListener(FlowExecutionListener listener) {
        return this.listeners.contains(listener);
    }

    public void removeListener(FlowExecutionListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListenerCriteria(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        if (this.containsListener(listener)) {
            ConditionalFlowExecutionListenerHolder listenerHolder = this.getHolder(listener);
            listenerHolder.remove(criteria);
            if (listenerHolder.isCriteriaSetEmpty()) {
                this.removeListener(listener);
            }
        }
    }

    protected FlowExecutionListenerCriteria convertEncodedListenerCriteria(String encodedCriteria) {
        return new TextToFlowExecutionListenerCriteria().convert(encodedCriteria);
    }

    private void setListenerCriteria(FlowExecutionListener listener, FlowExecutionListenerCriteria criteria) {
        this.setListenersCriteria(new FlowExecutionListener[]{listener}, criteria);
    }

    private void setListenersCriteria(FlowExecutionListener[] listeners, FlowExecutionListenerCriteria criteria) {
        for (int i = 0; i < listeners.length; ++i) {
            FlowExecutionListener listener = listeners[i];
            if (this.containsListener(listener)) {
                this.removeListener(listener);
            }
            this.addListener(listener, criteria);
        }
    }

    private static final class ConditionalFlowExecutionListenerHolder {
        private FlowExecutionListener listener;
        private Set criteriaSet = CollectionFactory.createLinkedSetIfPossible((int)3);

        public ConditionalFlowExecutionListenerHolder(FlowExecutionListener listener) {
            this.listener = listener;
        }

        public FlowExecutionListener getListener() {
            return this.listener;
        }

        public void add(FlowExecutionListenerCriteria criteria) {
            this.criteriaSet.add(criteria);
        }

        public void remove(FlowExecutionListenerCriteria criteria) {
            this.criteriaSet.remove(criteria);
        }

        public boolean isCriteriaSetEmpty() {
            return this.criteriaSet.isEmpty();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConditionalFlowExecutionListenerHolder)) {
                return false;
            }
            return this.listener.equals(((ConditionalFlowExecutionListenerHolder)o).listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean listenerAppliesTo(Flow flow) {
            Iterator it = this.criteriaSet.iterator();
            while (it.hasNext()) {
                FlowExecutionListenerCriteria criteria = (FlowExecutionListenerCriteria)it.next();
                if (!criteria.appliesTo(flow)) continue;
                return true;
            }
            return false;
        }
    }
}

