/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecutionListenerCriteria;

public class FlowExecutionListenerCriteriaFactory {
    public static FlowExecutionListenerCriteria allFlows() {
        return new WildcardFlowExecutionListenerCriteria();
    }

    public static FlowExecutionListenerCriteria flow(String flowId) {
        return new FlowIdFlowExecutionListenerCriteria(flowId);
    }

    public static FlowExecutionListenerCriteria flows(String[] flowIds) {
        return new FlowIdFlowExecutionListenerCriteria(flowIds);
    }

    public static class FlowIdFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private String[] flowIds;

        public FlowIdFlowExecutionListenerCriteria(String flowId) {
            Assert.notNull((Object)flowId, (String)"The flow id is required");
            this.flowIds = new String[]{flowId};
        }

        public FlowIdFlowExecutionListenerCriteria(String[] flowIds) {
            Assert.notEmpty((Object[])flowIds, (String)"The flow id is required");
            this.flowIds = flowIds;
        }

        public boolean appliesTo(Flow flow) {
            for (int i = 0; i < this.flowIds.length; ++i) {
                if (!this.flowIds[i].equals(flow.getId())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("flowIds", (Object)StylerUtils.style((Object)this.flowIds)).toString();
        }
    }

    public static class WildcardFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        public static final String WILDCARD_FLOW_ID = "*";

        public boolean appliesTo(Flow flow) {
            return true;
        }

        public String toString() {
            return WILDCARD_FLOW_ID;
        }
    }
}

