/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryCreator;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepositoryFactory;

public class SharedMapFlowExecutionRepositoryFactory
extends AbstractFlowExecutionRepositoryFactory {
    private SharedMapLocator sharedMapLocator = new SessionMapLocator();

    public SharedMapFlowExecutionRepositoryFactory(FlowExecutionRepositoryCreator repositoryCreator) {
        super(repositoryCreator);
    }

    public SharedMapLocator getSharedMapLocator() {
        return this.sharedMapLocator;
    }

    public void setSharedMapLocator(SharedMapLocator sharedMapLocator) {
        this.sharedMapLocator = sharedMapLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionRepository getRepository(ExternalContext context) {
        ExternalContext.SharedMap repositoryMap = this.sharedMapLocator.getMap(context);
        Object object = repositoryMap.getMutex();
        synchronized (object) {
            Object repositoryKey = this.getRepositoryKey();
            FlowExecutionRepository repository = (FlowExecutionRepository)repositoryMap.get(repositoryKey);
            if (repository == null) {
                repository = this.getRepositoryCreator().createRepository();
                repositoryMap.put(repositoryKey, repository);
            } else {
                this.getRepositoryCreator().rehydrateRepository(repository);
            }
            return repository;
        }
    }

    protected Object getRepositoryKey() {
        return this.getRepositoryCreator().getClass().getName();
    }

    public static class SessionMapLocator
    implements SharedMapLocator {
        public ExternalContext.SharedMap getMap(ExternalContext context) {
            return context.getSessionMap().getSharedMap();
        }
    }

    public static interface SharedMapLocator {
        public ExternalContext.SharedMap getMap(ExternalContext var1);
    }
}

