/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.jsf.DecoratingNavigationHandler;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.FlowNavigationHandlerArgumentExtractor;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.jsf.ViewIdResolver;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ConversationRedirect;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class FlowNavigationHandler
extends DecoratingNavigationHandler {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowNavigationHandlerArgumentExtractor();
    private ViewIdResolver viewIdResolver = new DefaultViewIdResolver();

    public FlowNavigationHandler() {
    }

    public FlowNavigationHandler(NavigationHandler originalNavigationHandler) {
        super(originalNavigationHandler);
    }

    public FlowExecutionRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(FlowExecutionRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public ViewIdResolver getViewIdResolver() {
        return this.viewIdResolver;
    }

    public void setViewIdResolver(ViewIdResolver viewIdResolver) {
        this.viewIdResolver = viewIdResolver;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome, NavigationHandler originalNavigationHandler) {
        JsfExternalContext context = new JsfExternalContext(facesContext, fromAction, outcome);
        FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
        if (holder != null) {
            FlowExecution flowExecution = holder.getFlowExecution();
            String eventId = this.argumentExtractor.extractEventId(context);
            ViewSelection selectedView = flowExecution.signalEvent(eventId, context);
            this.renderView(selectedView, context);
        } else {
            String flowId = this.argumentExtractor.extractFlowId(context);
            if (StringUtils.hasText((String)flowId)) {
                FlowExecution flowExecution = this.getRepository(context).createFlowExecution(flowId);
                ViewSelection selectedView = flowExecution.start(context);
                FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(flowExecution), facesContext);
                this.renderView(selectedView, context);
            } else {
                originalNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
            }
        }
    }

    protected FlowExecutionRepository getRepository(JsfExternalContext context) {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = FlowFacesUtils.getRepositoryFactory(context.getFacesContext());
        }
        return this.repositoryFactory.getRepository(context);
    }

    public void renderView(ViewSelection selectedView, JsfExternalContext context) {
        if (selectedView == ViewSelection.NULL_VIEW) {
            return;
        }
        FacesContext facesContext = context.getFacesContext();
        if (selectedView instanceof ApplicationView) {
            ApplicationView forward = (ApplicationView)selectedView;
            this.putInto(facesContext.getExternalContext().getRequestMap(), forward.getModel());
            if (forward.getViewName() == null) {
                return;
            }
            ViewHandler handler = facesContext.getApplication().getViewHandler();
            UIViewRoot view = handler.createView(facesContext, this.viewIdResolver.resolveViewId(forward.getViewName()));
            facesContext.setViewRoot(view);
        } else if (selectedView instanceof ConversationRedirect) {
            FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
            String conversationUrl = this.argumentExtractor.createConversationUrl(holder.getFlowExecutionKey().getConversationId(), context);
            this.sendRedirect(conversationUrl, facesContext);
        } else if (selectedView instanceof ExternalRedirect) {
            FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
            String externalUrl = this.argumentExtractor.createExternalUrl((ExternalRedirect)selectedView, holder.getFlowExecutionKey(), context);
            this.sendRedirect(externalUrl, facesContext);
        } else if (selectedView instanceof FlowRedirect) {
            String flowUrl = this.argumentExtractor.createFlowUrl((FlowRedirect)selectedView, context);
            this.sendRedirect(flowUrl, facesContext);
        } else {
            throw new IllegalArgumentException("Don't know how to handle view selection " + selectedView);
        }
    }

    private void sendRedirect(String url, FacesContext facesContext) {
        try {
            facesContext.getExternalContext().redirect(url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not send redirect to " + url);
        }
    }

    private void putInto(Map targetMap, Map map) {
        try {
            targetMap.putAll(map);
        }
        catch (UnsupportedOperationException e) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class DefaultViewIdResolver
    implements ViewIdResolver {
        public String resolveViewId(String viewName) {
            return viewName;
        }
    }
}

