/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public class FlowPhaseListener
implements PhaseListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutionRepositoryFactory repositoryFactory;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowExecutorArgumentExtractor();

    public FlowExecutionRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(FlowExecutionRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.restoreFlowExecution(event.getFacesContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.prepareView(event.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.updateFlowExecution(event.getFacesContext());
        }
    }

    protected void restoreFlowExecution(FacesContext facesContext) {
        JsfExternalContext context = new JsfExternalContext(facesContext);
        FlowExecutionKey flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context);
        if (flowExecutionKey != null) {
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded existing flow execution from repository with id '" + flowExecutionKey + "'"));
            }
            FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(flowExecutionKey, flowExecution), facesContext);
        }
    }

    protected FlowExecutionRepository getRepository(JsfExternalContext context) {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = FlowFacesUtils.getRepositoryFactory(context.getFacesContext());
        }
        return this.repositoryFactory.getRepository(context);
    }

    protected void prepareView(FacesContext facesContext) {
        FlowExecution flowExecution;
        FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
        if (holder != null && (flowExecution = holder.getFlowExecution()).isActive()) {
            FlowExecutionKey flowExecutionKey = holder.getFlowExecutionKey();
            FlowExecutionRepository repository = this.getRepository(new JsfExternalContext(facesContext));
            flowExecutionKey = flowExecutionKey == null ? repository.generateKey(flowExecution) : repository.generateKey(flowExecution, flowExecutionKey.getConversationId());
            holder.setFlowExecutionKey(flowExecutionKey);
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            this.argumentExtractor.put(flowExecutionKey, requestMap);
            this.argumentExtractor.put(flowExecution, requestMap);
        }
    }

    protected void updateFlowExecution(FacesContext facesContext) {
        FlowExecutionHolder holder = FlowExecutionHolderUtils.getFlowExecutionHolder(facesContext);
        if (holder != null) {
            FlowExecution flowExecution = holder.getFlowExecution();
            FlowExecutionRepository repository = this.getRepository(new JsfExternalContext(facesContext));
            if (flowExecution.isActive()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving continuation to repository with key " + holder.getFlowExecutionKey()));
                }
                repository.putFlowExecution(holder.getFlowExecutionKey(), flowExecution);
            } else {
                Serializable conversationId = holder.getFlowExecutionKey().getConversationId();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Removing conversation in repository with id '" + conversationId + "'"));
                }
                repository.invalidateConversation(conversationId);
            }
        }
    }
}

