/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.io.Serializable;
import java.util.Iterator;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.FlowRedirect;

public class RequestPathFlowExecutorArgumentExtractor
extends FlowExecutorArgumentExtractor {
    private static final String CONVERSATION_ID_PREFIX = "/_c";

    public String extractFlowId(ExternalContext context) {
        String extractedFilename;
        String requestPathInfo = context.getRequestPathInfo();
        if (requestPathInfo == null) {
            requestPathInfo = "";
        }
        return StringUtils.hasText((String)(extractedFilename = WebUtils.extractFilenameFromUrlPath((String)requestPathInfo))) ? extractedFilename : super.extractFlowId(context);
    }

    public Serializable extractConversationId(ExternalContext context) {
        String requestPathInfo = context.getRequestPathInfo();
        if (requestPathInfo != null && requestPathInfo.startsWith(CONVERSATION_ID_PREFIX)) {
            return requestPathInfo.substring(CONVERSATION_ID_PREFIX.length());
        }
        return super.extractConversationId(context);
    }

    public String createFlowUrl(FlowRedirect flowRedirect, ExternalContext context) {
        StringBuffer flowUrl = new StringBuffer();
        flowUrl.append(context.getDispatcherPath());
        flowUrl.append('/');
        flowUrl.append(flowRedirect.getFlowId());
        if (!flowRedirect.getInput().isEmpty()) {
            flowUrl.append('/');
            Iterator it = flowRedirect.getInput().values().iterator();
            while (it.hasNext()) {
                flowUrl.append(this.encodeValue(it.next()));
                if (!it.hasNext()) continue;
                flowUrl.append('/');
            }
        }
        return flowUrl.toString();
    }

    public String createConversationUrl(Serializable conversationId, ExternalContext context) {
        return context.getDispatcherPath() + CONVERSATION_ID_PREFIX + conversationId;
    }
}

