/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.registry.FlowRegistrarSupport;
import org.springframework.webflow.registry.FlowRegistry;

public abstract class ExternalizedFlowRegistrar
extends FlowRegistrarSupport {
    private Set flowLocations = new HashSet();
    private Set flowDefinitions = new HashSet();

    public void setFlowLocations(Resource[] flowLocations) {
        this.flowLocations = new HashSet<Resource>(Arrays.asList(flowLocations));
    }

    public void setFlowDefinitions(ExternalizedFlowDefinition[] flowDefinitions) {
        this.flowDefinitions = new HashSet<ExternalizedFlowDefinition>(Arrays.asList(flowDefinitions));
    }

    public boolean addFlowLocation(Resource flowLocation) {
        return this.flowLocations.add(flowLocation);
    }

    public boolean addFlowLocations(Resource[] flowLocations) {
        if (flowLocations == null) {
            return false;
        }
        return this.flowLocations.addAll(Arrays.asList(flowLocations));
    }

    public boolean addFlowDefinition(ExternalizedFlowDefinition flowDefinition) {
        return this.flowDefinitions.add(flowDefinition);
    }

    public boolean addFlowDefinitions(ExternalizedFlowDefinition[] flowDefinitions) {
        if (flowDefinitions == null) {
            return false;
        }
        return this.flowDefinitions.addAll(Arrays.asList(flowDefinitions));
    }

    public void registerFlows(FlowRegistry registry, FlowArtifactFactory flowArtifactFactory) {
        this.processFlowLocations(registry, flowArtifactFactory);
        this.processFlowDefinitions(registry, flowArtifactFactory);
    }

    protected void processFlowLocations(FlowRegistry registry, FlowArtifactFactory flowArtifactFactory) {
        Iterator it = this.flowLocations.iterator();
        while (it.hasNext()) {
            this.registerFlow((Resource)it.next(), registry, flowArtifactFactory);
        }
    }

    protected void processFlowDefinitions(FlowRegistry registry, FlowArtifactFactory flowArtifactFactory) {
        Iterator it = this.flowDefinitions.iterator();
        while (it.hasNext()) {
            ExternalizedFlowDefinition definition = (ExternalizedFlowDefinition)it.next();
            FlowBuilder builder = this.createFlowBuilder(definition.getLocation(), flowArtifactFactory);
            this.registerFlow(definition, builder, registry);
        }
    }

    protected void registerFlow(Resource location, FlowRegistry registry, FlowArtifactFactory flowArtifactFactory) {
        FlowBuilder builder = this.createFlowBuilder(location, flowArtifactFactory);
        this.registerFlow(this.getFlowId(location), builder, registry);
    }

    protected abstract boolean isFlowDefinition(File var1);

    protected abstract String getFlowId(Resource var1);

    protected abstract FlowBuilder createFlowBuilder(Resource var1, FlowArtifactFactory var2);

    public String toString() {
        return new ToStringCreator((Object)this).append("flowLocations", (Object)this.flowLocations).append("flowDefinitions", (Object)this.flowDefinitions).toString();
    }
}

