/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ConversationRedirect;

public class ApplicationViewSelector
implements ViewSelector,
Serializable {
    private String viewName;
    private boolean requestConversationRedirect;

    public ApplicationViewSelector(String viewName) {
        this.setViewName(viewName);
    }

    public ApplicationViewSelector(String viewName, boolean requestConversationRedirect) {
        this.setViewName(viewName);
        this.setRequestConversationRedirect(requestConversationRedirect);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        Assert.hasText((String)viewName, (String)"The view name is required");
        this.viewName = viewName;
    }

    public boolean isRequestConversationRedirect() {
        return this.requestConversationRedirect;
    }

    public void setRequestConversationRedirect(boolean requestConversationRedirect) {
        this.requestConversationRedirect = requestConversationRedirect;
    }

    public ViewSelection makeSelection(RequestContext context) {
        ApplicationView view = new ApplicationView(this.getViewName(), context.getModel().getMap());
        if (this.isRequestConversationRedirect()) {
            return new ConversationRedirect(view);
        }
        return view;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("viewName", (Object)this.viewName).append("requestConversationRedirect", this.requestConversationRedirect).toString();
    }
}

