/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.ViewSelection;

public final class ExternalRedirect
extends ViewSelection {
    private final String url;
    private final boolean contextRelative;

    public ExternalRedirect(String url, boolean contextRelative) {
        Assert.notNull((Object)url, (String)"The external URL to redirect to is required");
        this.url = url;
        this.contextRelative = contextRelative;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExternalRedirect)) {
            return false;
        }
        ExternalRedirect other = (ExternalRedirect)o;
        return this.url.equals(other.url) && this.contextRelative == other.contextRelative;
    }

    public int hashCode() {
        return this.url.hashCode() + (this.contextRelative ? 1 : 0) * 29;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("url", (Object)this.url).append("contextRelative", this.contextRelative).toString();
    }
}

