/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.test.MockFlowSession;

public class MockFlowExecutionContext
implements FlowExecutionContext {
    private Flow rootFlow;
    private FlowSession activeSession;
    private AttributeMap scope = new AttributeMap();

    public MockFlowExecutionContext() {
        this.activeSession = new MockFlowSession();
        this.rootFlow = this.activeSession.getFlow();
    }

    public MockFlowExecutionContext(Flow rootFlow) {
        this.rootFlow = rootFlow;
        this.activeSession = new MockFlowSession(rootFlow);
    }

    public String getCaption() {
        return "Mock flow execution context";
    }

    public boolean isActive() {
        return this.activeSession != null;
    }

    public Flow getFlow() {
        return this.rootFlow;
    }

    public FlowSession getActiveSession() throws IllegalStateException {
        if (this.activeSession == null) {
            throw new IllegalStateException("No flow session is active");
        }
        return this.activeSession;
    }

    public AttributeMap getScope() {
        return this.scope;
    }

    public void setRootFlow(Flow rootFlow) {
        this.rootFlow = rootFlow;
    }

    public void setActiveSession(FlowSession activeSession) {
        this.activeSession = activeSession;
    }

    public void setScope(AttributeMap scope) {
        this.scope = scope;
    }

    public MockFlowSession getMockActiveSession() {
        return (MockFlowSession)this.activeSession;
    }
}

