/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.impl.RSS090Generator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class RSS10Generator
extends RSS090Generator {
    private static final String RSS_URI = "http://purl.org/rss/1.0/";
    private static final Namespace RSS_NS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");

    public RSS10Generator() {
        super("rss_1.0");
    }

    protected RSS10Generator(String feedType) {
        super(feedType);
    }

    protected Namespace getFeedNamespace() {
        return RSS_NS;
    }

    protected void populateChannel(Channel channel, Element eChannel) {
        super.populateChannel(channel, eChannel);
        List items = channel.getItems();
        if (items.size() > 0) {
            Element eItems = new Element("items", this.getFeedNamespace());
            Element eSeq = new Element("Seq", this.getRDFNamespace());
            for (int i = 0; i < items.size(); ++i) {
                Item item = (Item)items.get(i);
                Element eLi = new Element("li", this.getRDFNamespace());
                String link = item.getLink();
                if (link != null) {
                    eLi.setAttribute("resource", link);
                }
                eSeq.addContent((Content)eLi);
            }
            eItems.addContent((Content)eSeq);
            eChannel.addContent((Content)eItems);
        }
    }

    protected void populateItem(Item item, Element eItem) {
        Description description;
        super.populateItem(item, eItem);
        String link = item.getLink();
        if (link != null) {
            eItem.setAttribute("about", link, this.getRDFNamespace());
        }
        if ((description = item.getDescription()) != null) {
            eItem.addContent((Content)this.generateSimpleElement("description", description.getValue()));
        }
    }

    protected void checkItemsConstraints(Element parent) throws FeedException {
    }

    protected void checkItemConstraints(Element eItem) throws FeedException {
        super.checkItemConstraints(eItem);
        this.checkLength(eItem, "description", 0, 500);
    }
}

