/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.Converter;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConverterForAtom03
implements Converter {
    private String _type;

    public ConverterForAtom03() {
        this("atom_0.3");
    }

    protected ConverterForAtom03(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void copyInto(WireFeed feed, SyndFeed syndFeed) {
        Date date;
        String copyright;
        Person author;
        String language;
        List aEntries;
        Feed aFeed = (Feed)feed;
        syndFeed.setModules(ModuleUtils.cloneModules(aFeed.getModules()));
        syndFeed.setEncoding(aFeed.getEncoding());
        syndFeed.setUri(aFeed.getId());
        syndFeed.setTitle(aFeed.getTitle());
        Link link = (Link)aFeed.getAlternateLinks().get(0);
        syndFeed.setLink(link.getHref());
        Content info = aFeed.getInfo();
        if (info != null) {
            syndFeed.setDescription(info.getValue());
        }
        if ((aEntries = aFeed.getEntries()) != null) {
            syndFeed.setEntries(this.createSyndEntries(aEntries));
        }
        if ((language = aFeed.getLanguage()) != null) {
            syndFeed.setLanguage(language);
        }
        if ((author = aFeed.getAuthor()) != null && author.getName() != null) {
            syndFeed.setAuthor(author.getName());
        }
        if ((copyright = aFeed.getCopyright()) != null) {
            syndFeed.setCopyright(copyright);
        }
        if ((date = aFeed.getModified()) != null) {
            syndFeed.setPublishedDate(date);
        }
    }

    protected List createSyndEntries(List atomEntries) {
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        for (int i = 0; i < atomEntries.size(); ++i) {
            syndEntries.add(this.createSyndEntry((Entry)atomEntries.get(i)));
        }
        return syndEntries;
    }

    protected SyndEntry createSyndEntry(Entry entry) {
        Date date;
        Person author;
        List contents;
        SyndEntryImpl syndEntry = new SyndEntryImpl();
        syndEntry.setModules(ModuleUtils.cloneModules(entry.getModules()));
        syndEntry.setTitle(entry.getTitle());
        Link link = (Link)entry.getAlternateLinks().get(0);
        syndEntry.setLink(link.getHref());
        String id = entry.getId();
        if (id != null) {
            syndEntry.setUri(entry.getId());
        } else {
            syndEntry.setUri(syndEntry.getLink());
        }
        Content content = entry.getSummary();
        if (content == null && (contents = entry.getContents()) != null && contents.size() > 0) {
            content = (Content)contents.get(0);
        }
        if (content != null) {
            SyndContentImpl sContent = new SyndContentImpl();
            sContent.setType(content.getType());
            sContent.setValue(content.getValue());
            syndEntry.setDescription(sContent);
        }
        if ((contents = entry.getContents()).size() > 0) {
            ArrayList<SyndContentImpl> sContents = new ArrayList<SyndContentImpl>();
            for (int i = 0; i < contents.size(); ++i) {
                content = (Content)contents.get(i);
                SyndContentImpl sContent = new SyndContentImpl();
                sContent.setType(content.getType());
                sContent.setValue(content.getValue());
                sContents.add(sContent);
            }
            syndEntry.setContents(sContents);
        }
        if ((author = entry.getAuthor()) != null && author.getName() != null) {
            syndEntry.setAuthor(author.getName());
        }
        if ((date = entry.getModified()) != null) {
            syndEntry.setPublishedDate(date);
        }
        return syndEntry;
    }

    public WireFeed createRealFeed(SyndFeed syndFeed) {
        String sDesc;
        Feed aFeed = new Feed(this.getType());
        aFeed.setModules(ModuleUtils.cloneModules(syndFeed.getModules()));
        aFeed.setEncoding(syndFeed.getEncoding());
        aFeed.setId(syndFeed.getUri());
        aFeed.setTitle(syndFeed.getTitle());
        String sLink = syndFeed.getLink();
        if (sLink != null) {
            Link link = new Link();
            link.setRel("alternate");
            link.setHref(sLink);
            ArrayList<Link> list = new ArrayList<Link>();
            list.add(link);
            aFeed.setAlternateLinks(list);
        }
        if ((sDesc = syndFeed.getDescription()) != null) {
            Content info = new Content();
            info.setValue(sDesc);
            aFeed.setInfo(info);
        }
        aFeed.setLanguage(syndFeed.getLanguage());
        String sAuthor = syndFeed.getAuthor();
        if (sAuthor != null) {
            Person person = new Person();
            person.setName(sAuthor);
            aFeed.setAuthor(person);
        }
        aFeed.setCopyright(syndFeed.getCopyright());
        aFeed.setModified(syndFeed.getPublishedDate());
        List sEntries = syndFeed.getEntries();
        if (sEntries != null) {
            aFeed.setEntries(this.createAtomEntries(sEntries));
        }
        return aFeed;
    }

    protected List createAtomEntries(List syndEntries) {
        ArrayList<Entry> atomEntries = new ArrayList<Entry>();
        for (int i = 0; i < syndEntries.size(); ++i) {
            atomEntries.add(this.createAtomEntry((SyndEntry)syndEntries.get(i)));
        }
        return atomEntries;
    }

    protected Entry createAtomEntry(SyndEntry sEntry) {
        String sAuthor;
        List contents;
        SyndContent sContent;
        Entry aEntry = new Entry();
        aEntry.setModules(ModuleUtils.cloneModules(sEntry.getModules()));
        aEntry.setId(sEntry.getUri());
        aEntry.setTitle(sEntry.getTitle());
        String sLink = sEntry.getLink();
        if (sLink != null) {
            Link link = new Link();
            link.setRel("alternate");
            link.setHref(sLink);
            ArrayList<Link> list = new ArrayList<Link>();
            list.add(link);
            aEntry.setAlternateLinks(list);
        }
        if ((sContent = sEntry.getDescription()) != null) {
            Content content = new Content();
            content.setType(sContent.getType());
            content.setValue(sContent.getValue());
            content.setMode("xml");
            aEntry.setSummary(content);
        }
        if ((contents = sEntry.getContents()).size() > 0) {
            ArrayList<Content> aContents = new ArrayList<Content>();
            for (int i = 0; i < contents.size(); ++i) {
                sContent = (SyndContentImpl)contents.get(i);
                Content content = new Content();
                content.setType(sContent.getType());
                content.setValue(sContent.getValue());
                content.setMode("xml");
                aContents.add(content);
            }
            aEntry.setContents(aContents);
        }
        if ((sAuthor = sEntry.getAuthor()) != null) {
            Person person = new Person();
            person.setName(sAuthor);
            aEntry.setAuthor(person);
        }
        aEntry.setModified(sEntry.getPublishedDate());
        return aEntry;
    }
}

