/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io;

import com.sun.syndication.io.XmlReaderException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlReader
extends Reader {
    private static final int PUSHBACK_MAX_SIZE = 1024;
    private static final String UTF_8 = "UTF-8";
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_16 = "UTF-16";
    private Reader _reader;
    private String _encoding;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([.[^; ]]*)");
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^<\\?xml.*encoding=\"(.*)\".*\\?>");
    private static final MessageFormat RAW_EX_1 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch");
    private static final MessageFormat RAW_EX_2 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM");
    private static final MessageFormat HTTP_EX_1 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL");
    private static final MessageFormat HTTP_EX_2 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch");
    private static final MessageFormat HTTP_EX_3 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME");

    public XmlReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public XmlReader(InputStream is) throws IOException {
        this(is, true);
    }

    public XmlReader(InputStream is, boolean lenient) throws IOException, XmlReaderException {
        try {
            this.doRawStream(is);
        }
        catch (XmlReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(null, ex);
        }
    }

    public XmlReader(URL url) throws IOException {
        this(url.openConnection());
    }

    public XmlReader(URLConnection conn) throws IOException {
        if (conn instanceof HttpURLConnection) {
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType());
            }
            catch (XmlReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else if (conn.getContentType() != null) {
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType());
            }
            catch (XmlReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else {
            try {
                this.doRawStream(conn.getInputStream());
            }
            catch (XmlReaderException ex) {
                this.doLenientDetection(null, ex);
            }
        }
    }

    public XmlReader(InputStream is, String httpContentType) throws IOException {
        this(is, httpContentType, true);
    }

    public XmlReader(InputStream is, String httpContentType, boolean lenient) throws IOException, XmlReaderException {
        try {
            this.doHttpStream(is, httpContentType);
        }
        catch (XmlReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(httpContentType, ex);
        }
    }

    private void doLenientDetection(String httpContentType, XmlReaderException ex) throws IOException {
        if (httpContentType != null && httpContentType.startsWith("text/html")) {
            httpContentType = httpContentType.substring("text/html".length());
            httpContentType = "text/xml" + httpContentType;
            try {
                this.doHttpStream(ex.getInputStream(), httpContentType);
                ex = null;
            }
            catch (XmlReaderException ex2) {
                ex = ex2;
            }
        }
        if (ex != null) {
            String encoding = ex.getXmlEncoding();
            if (encoding == null) {
                encoding = ex.getContentTypeEncoding();
            }
            if (encoding == null) {
                encoding = UTF_8;
            }
            this.prepareReader(ex.getInputStream(), encoding);
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int read(char[] buf, int offset, int len) throws IOException {
        return this._reader.read(buf, offset, len);
    }

    public void close() throws IOException {
        this._reader.close();
    }

    private void doRawStream(InputStream is) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is, 1024);
        String bomEnc = XmlReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlReader.getXMLPrologEncoding(pis, xmlGuessEnc);
        String encoding = XmlReader.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, pis);
        this.prepareReader(pis, encoding);
    }

    private void doHttpStream(InputStream is, String httpContentType) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(is, 1024);
        String cTMime = XmlReader.getContentTypeMime(httpContentType);
        String cTEnc = XmlReader.getContentTypeEncoding(httpContentType);
        String bomEnc = XmlReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlReader.getXMLPrologEncoding(pis, xmlGuessEnc);
        String encoding = XmlReader.calculateHttpEncoding(cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, pis);
        this.prepareReader(pis, encoding);
    }

    private void prepareReader(InputStream is, String encoding) throws IOException {
        this._reader = new InputStreamReader(is, encoding);
        this._encoding = encoding;
    }

    /*
     * WARNING - void declaration
     */
    private static String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is) throws IOException {
        void var4_4;
        String encoding;
        if (bomEnc == null) {
            encoding = xmlGuessEnc == null || xmlEnc == null ? UTF_8 : (xmlEnc.equals(UTF_16) && (xmlGuessEnc.equals(UTF_16BE) || xmlGuessEnc.equals(UTF_16LE)) ? xmlGuessEnc : xmlEnc);
        } else if (bomEnc.equals(UTF_8)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(UTF_8)) {
                throw new XmlReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_8)) {
                throw new XmlReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            encoding = UTF_8;
        } else if (bomEnc.equals(UTF_16BE) || bomEnc.equals(UTF_16LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                throw new IOException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_16) && !xmlEnc.equals(bomEnc)) {
                throw new XmlReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            encoding = bomEnc;
        } else {
            throw new XmlReaderException(RAW_EX_2.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
        }
        return var4_4;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String calculateHttpEncoding(String cTMime, String cTEnc, String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is) throws IOException {
        String encoding;
        void var8_8;
        boolean appXml = XmlReader.isAppXml(cTMime);
        boolean textXml = XmlReader.isTextXml(cTMime);
        if (!appXml && !textXml) throw new XmlReaderException(HTTP_EX_3.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
        if (cTEnc == null) {
            if (!appXml) return var8_8;
            encoding = XmlReader.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, is);
            return var8_8;
        } else {
            if (bomEnc != null && (cTEnc.equals(UTF_16BE) || cTEnc.equals(UTF_16LE))) {
                throw new XmlReaderException(HTTP_EX_1.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            if (cTEnc.equals(UTF_16)) {
                if (bomEnc == null || !bomEnc.startsWith(UTF_16)) throw new XmlReaderException(HTTP_EX_2.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
                encoding = bomEnc;
                return var8_8;
            } else {
                encoding = cTEnc;
            }
        }
        return var8_8;
    }

    private static String getContentTypeMime(String httpContentType) {
        String mime = null;
        if (httpContentType != null) {
            int i = httpContentType.indexOf(";");
            mime = (i == -1 ? httpContentType : httpContentType.substring(0, i)).trim();
        }
        return mime;
    }

    private static String getContentTypeEncoding(String httpContentType) {
        int i;
        String encoding = null;
        if (httpContentType != null && (i = httpContentType.indexOf(";")) > -1) {
            String postMime = httpContentType.substring(i + 1);
            Matcher m = CHARSET_PATTERN.matcher(postMime);
            encoding = m.find() ? m.group(1) : null;
            encoding = encoding != null ? encoding.toUpperCase() : null;
        }
        return encoding;
    }

    private static String getBOMEncoding(PushbackInputStream is) throws IOException {
        String encoding = null;
        int[] bytes = new int[]{is.read(), is.read(), is.read()};
        if (bytes[0] == 254 && bytes[1] == 255) {
            encoding = UTF_16BE;
            is.unread(bytes[2]);
        } else if (bytes[0] == 255 && bytes[1] == 254) {
            encoding = UTF_16LE;
            is.unread(bytes[2]);
        } else if (bytes[0] == 239 && bytes[1] == 187 && bytes[2] == 191) {
            encoding = UTF_8;
        } else {
            for (int i = bytes.length - 1; i >= 0; --i) {
                is.unread(bytes[i]);
            }
        }
        return encoding;
    }

    private static String getXMLGuessEncoding(PushbackInputStream is) throws IOException {
        String encoding = null;
        int[] bytes = new int[]{is.read(), is.read(), is.read(), is.read()};
        for (int i = bytes.length - 1; i >= 0; --i) {
            is.unread(bytes[i]);
        }
        if (bytes[0] == 0 && bytes[1] == 60 && bytes[2] == 0 && bytes[3] == 63) {
            encoding = UTF_16BE;
        } else if (bytes[0] == 60 && bytes[1] == 0 && bytes[2] == 63 && bytes[3] == 0) {
            encoding = UTF_16LE;
        } else if (bytes[0] == 60 && bytes[1] == 63 && bytes[2] == 120 && bytes[3] == 109) {
            encoding = UTF_8;
        }
        return encoding;
    }

    private static String getXMLPrologEncoding(PushbackInputStream is, String guessedEnc) throws IOException {
        String encoding = null;
        if (guessedEnc != null) {
            byte[] bytes = new byte[1024];
            int offset = 0;
            int max = 1024;
            int c = is.read(bytes, offset, max);
            while (c != -1 && offset < 1024) {
                c = is.read(bytes, offset += c, max -= c);
            }
            int bytesRead = offset;
            if (bytesRead > 0) {
                is.unread(bytes, 0, bytesRead);
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes, 0, bytesRead), guessedEnc);
                BufferedReader br = new BufferedReader(reader);
                String prolog = br.readLine();
                Matcher m = ENCODING_PATTERN.matcher(prolog);
                encoding = m.find() ? m.group(1).toUpperCase() : null;
            }
        }
        return encoding;
    }

    private static boolean isAppXml(String mime) {
        return mime != null && (mime.equals("application/xml") || mime.equals("application/xml-dtd") || mime.equals("application/xml-external-parsed-entity") || mime.startsWith("application/") && mime.endsWith("+xml"));
    }

    private static boolean isTextXml(String mime) {
        return mime != null && (mime.equals("text/xml") || mime.equals("text/xml-external-parsed-entity") || mime.startsWith("text/") && mime.endsWith("+xml"));
    }
}

