/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.DCSubjectImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import com.sun.syndication.io.impl.DateParser;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class DCModuleParser
implements ModuleParser {
    private static final String RDF_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String TAXO_URI = "http://purl.org/rss/1.0/modules/taxonomy/";

    public String getNamespaceUri() {
        return "http://purl.org/dc/elements/1.1/";
    }

    private Namespace getDCNamespace() {
        return Namespace.getNamespace((String)"http://purl.org/dc/elements/1.1/");
    }

    public Module parse(Element dcRoot) {
        List eList;
        boolean foundSomething = false;
        DCModuleImpl dcm = new DCModuleImpl();
        Element e = dcRoot.getChild("title", this.getDCNamespace());
        if (e != null) {
            foundSomething = true;
            dcm.setTitle(e.getText());
        }
        if ((e = dcRoot.getChild("creator", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setCreator(e.getText());
        }
        if ((eList = dcRoot.getChildren("subject", this.getDCNamespace())).size() > 0) {
            foundSomething = true;
            dcm.setSubjects(this.parseSubjects(eList));
        }
        if ((e = dcRoot.getChild("description", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setDescription(e.getText());
        }
        if ((e = dcRoot.getChild("publisher", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setPublisher(e.getText());
        }
        if ((eList = dcRoot.getChildren("contributor", this.getDCNamespace())).size() > 0) {
            foundSomething = true;
            dcm.setContributors(this.parseContributors(eList));
        }
        if ((e = dcRoot.getChild("date", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setDate(DateParser.parseW3CDateTime(e.getText()));
        }
        if ((e = dcRoot.getChild("type", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setType(e.getText());
        }
        if ((e = dcRoot.getChild("format", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setFormat(e.getText());
        }
        if ((e = dcRoot.getChild("identifier", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setIdentifier(e.getText());
        }
        if ((e = dcRoot.getChild("source", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setSource(e.getText());
        }
        if ((e = dcRoot.getChild("language", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setLanguage(e.getText());
        }
        if ((e = dcRoot.getChild("relation", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setRelation(e.getText());
        }
        if ((e = dcRoot.getChild("coverage", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setCoverage(e.getText());
        }
        if ((e = dcRoot.getChild("rights", this.getDCNamespace())) != null) {
            foundSomething = true;
            dcm.setRights(e.getText());
        }
        return foundSomething ? dcm : null;
    }

    private String getTaxonomy(Element desc) {
        Attribute a;
        String d = null;
        Element taxo = desc.getChild("topic", Namespace.getNamespace((String)TAXO_URI));
        if (taxo != null && (a = taxo.getAttribute("resource", Namespace.getNamespace((String)RDF_URI))) != null) {
            d = a.getValue();
        }
        return d;
    }

    private List parseSubjects(List eList) {
        ArrayList<DCSubjectImpl> subjects = new ArrayList<DCSubjectImpl>();
        for (int i = 0; i < eList.size(); ++i) {
            Element eSubject = (Element)eList.get(i);
            Element eDesc = eSubject.getChild("Description", Namespace.getNamespace((String)RDF_URI));
            if (eDesc != null) {
                String taxonomy = this.getTaxonomy(eDesc);
                List eValues = eDesc.getChildren("value", Namespace.getNamespace((String)RDF_URI));
                for (int j = 0; j < eValues.size(); ++j) {
                    Element eValue = (Element)eValues.get(j);
                    DCSubjectImpl subject = new DCSubjectImpl();
                    subject.setTaxonomyUri(taxonomy);
                    subject.setValue(eValue.getText());
                    subjects.add(subject);
                }
                continue;
            }
            DCSubjectImpl subject = new DCSubjectImpl();
            subject.setValue(eSubject.getText());
            subjects.add(subject);
        }
        return subjects;
    }

    private List parseContributors(List eList) {
        ArrayList<String> contributors = new ArrayList<String>();
        for (int i = 0; i < eList.size(); ++i) {
            Element e = (Element)eList.get(i);
            contributors.add(e.getText());
        }
        return contributors;
    }
}

