/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Image;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.rss.TextInput;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.impl.BaseWireFeedParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class RSS090Parser
extends BaseWireFeedParser {
    private static final String RDF_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RSS_URI = "http://my.netscape.com/rdf/simple/0.9/";

    public RSS090Parser() {
        this("rss_0.9");
    }

    protected RSS090Parser(String type) {
        super(type);
    }

    public boolean isMyType(Document document) {
        boolean ok = false;
        Namespace rdfNS = Namespace.getNamespace((String)RDF_URI);
        Namespace rssNS = Namespace.getNamespace((String)RSS_URI);
        Element rssRoot = document.getRootElement();
        Namespace defaultNS = rssRoot.getNamespace();
        List additionalNSs = rssRoot.getAdditionalNamespaces();
        boolean bl = ok = defaultNS != null && defaultNS.equals((Object)rdfNS);
        if (ok) {
            if (additionalNSs == null) {
                ok = false;
            } else {
                ok = false;
                for (int i = 0; !ok && i < additionalNSs.size(); ++i) {
                    ok = rssNS.equals(additionalNSs.get(i));
                }
            }
        }
        return ok;
    }

    public WireFeed parse(Document document, boolean validate) throws IllegalArgumentException, FeedException {
        if (validate) {
            this.validateFeed(document);
        }
        Element rssRoot = document.getRootElement();
        return this.parseChannel(rssRoot);
    }

    protected void validateFeed(Document document) throws FeedException {
    }

    protected Namespace getRSSNamespace() {
        return Namespace.getNamespace((String)RSS_URI);
    }

    protected WireFeed parseChannel(Element rssRoot) {
        Element eChannel = rssRoot.getChild("channel", this.getRSSNamespace());
        Channel channel = new Channel(this.getType());
        Element e = eChannel.getChild("title", this.getRSSNamespace());
        if (e != null) {
            channel.setTitle(e.getText());
        }
        if ((e = eChannel.getChild("link", this.getRSSNamespace())) != null) {
            channel.setLink(e.getText());
        }
        if ((e = eChannel.getChild("description", this.getRSSNamespace())) != null) {
            channel.setDescription(e.getText());
        }
        channel.setImage(this.parseImage(rssRoot));
        channel.setTextInput(this.parseTextInput(rssRoot));
        channel.setItems(this.parseItems(rssRoot));
        channel.setModules(this.parseFeedModules(eChannel));
        return channel;
    }

    protected List getItems(Element rssRoot) {
        return rssRoot.getChildren("item", this.getRSSNamespace());
    }

    protected Element getImage(Element rssRoot) {
        return rssRoot.getChild("image", this.getRSSNamespace());
    }

    protected Element getTextInput(Element rssRoot) {
        return rssRoot.getChild("textinput", this.getRSSNamespace());
    }

    protected Image parseImage(Element rssRoot) {
        Image image = null;
        Element eImage = this.getImage(rssRoot);
        if (eImage != null) {
            image = new Image();
            Element e = eImage.getChild("title", this.getRSSNamespace());
            if (e != null) {
                image.setTitle(e.getText());
            }
            if ((e = eImage.getChild("url", this.getRSSNamespace())) != null) {
                image.setUrl(e.getText());
            }
            if ((e = eImage.getChild("link", this.getRSSNamespace())) != null) {
                image.setLink(e.getText());
            }
        }
        return image;
    }

    protected List parseItems(Element rssRoot) {
        List eItems = this.getItems(rssRoot);
        ArrayList<Item> items = new ArrayList<Item>();
        Iterator i = eItems.iterator();
        while (i.hasNext()) {
            Element eItem = (Element)i.next();
            items.add(this.parseItem(rssRoot, eItem));
        }
        return items;
    }

    protected Item parseItem(Element rssRoot, Element eItem) {
        Item item = new Item();
        Element e = eItem.getChild("title", this.getRSSNamespace());
        if (e != null) {
            item.setTitle(e.getText());
        }
        if ((e = eItem.getChild("link", this.getRSSNamespace())) != null) {
            item.setLink(e.getText());
        }
        item.setModules(this.parseItemModules(eItem));
        return item;
    }

    protected TextInput parseTextInput(Element rssRoot) {
        TextInput textInput = null;
        Element eTextInput = this.getTextInput(rssRoot);
        if (eTextInput != null) {
            textInput = new TextInput();
            Element e = eTextInput.getChild("title", this.getRSSNamespace());
            if (e != null) {
                textInput.setTitle(e.getText());
            }
            if ((e = eTextInput.getChild("description", this.getRSSNamespace())) != null) {
                textInput.setDescription(e.getText());
            }
            if ((e = eTextInput.getChild("name", this.getRSSNamespace())) != null) {
                textInput.setName(e.getText());
            }
            if ((e = eTextInput.getChild("link", this.getRSSNamespace())) != null) {
                textInput.setLink(e.getText());
            }
        }
        return textInput;
    }
}

