/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] fields;
    private final Object[] oldFields;
    private final Object lastVersion;
    private final Object nextVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object[] updatedState;
    private final Object rowId;
    private Object cacheEntry;
    private CacheConcurrencyStrategy.SoftLock lock;

    public EntityUpdateAction(Serializable id, Object[] fields, int[] dirtyProperties, boolean hasDirtyCollection, Object[] oldFields, Object lastVersion, Object nextVersion, Object instance, Object[] updatedState, Object rowId, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.fields = fields;
        this.oldFields = oldFields;
        this.lastVersion = lastVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.updatedState = updatedState;
        this.rowId = rowId;
    }

    public void execute() throws HibernateException {
        EntityEntry entry;
        CacheKey ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        PreUpdateEvent preEvent = new PreUpdateEvent(instance, id, this.fields, this.oldFields, persister, session);
        boolean veto = session.getListeners().getPreUpdateEventListener().onPreUpdate(preEvent);
        SessionFactoryImplementor factory = this.getSession().getFactory();
        if (persister.hasCache()) {
            ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            this.lock = persister.getCache().lock(ck, this.lastVersion);
        } else {
            ck = null;
        }
        if (!veto) {
            persister.update(id, this.fields, this.dirtyFields, this.hasDirtyCollection, this.oldFields, this.lastVersion, instance, this.rowId, session);
        }
        if ((entry = this.getSession().getPersistenceContext().getEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.postUpdate(instance, this.updatedState, this.nextVersion);
        if (persister.hasCache()) {
            if (persister.isCacheInvalidationRequired()) {
                persister.getCache().evict(ck);
            } else {
                CacheEntry ce = new CacheEntry(this.fields, persister, persister.hasUninitializedLazyProperties(instance, session.getEntityMode()), this.getSession(), instance);
                this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
                boolean put = persister.getCache().update(ck, this.cacheEntry);
                if (put && factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
                }
            }
        }
        PostUpdateEvent postEvent = new PostUpdateEvent(instance, id, this.fields, this.oldFields, persister, session);
        session.getListeners().getPostUpdateEventListener().onPostUpdate(postEvent);
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().updateEntity(this.getPersister().getEntityName());
        }
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        EntityPersister persister = this.getPersister();
        if (persister.hasCache()) {
            CacheKey ck = new CacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            if (success && !persister.isCacheInvalidationRequired()) {
                boolean put = persister.getCache().afterUpdate(ck, this.cacheEntry, this.nextVersion, this.lock);
                if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
                }
            } else {
                persister.getCache().release(ck, this.lock);
            }
        }
    }
}

