/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.Assert;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        Assert.notEmpty((Object[])patterns, (String)"'patterns' cannot be null or empty.");
        this.patterns = patterns;
        this.initPatternRepresentation(patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(new String[]{excludedPattern});
    }

    public void setExcludedPatterns(String[] excludedPatterns) {
        Assert.notEmpty((Object[])excludedPatterns, (String)"'excludedPatterns' cannot be null or empty.");
        this.excludedPatterns = excludedPatterns;
        this.initExcludedPatternRepresentation(excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    public final boolean matches(Method method, Class targetClass) {
        String patt = method.getDeclaringClass().getName() + "." + method.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            boolean matched = this.matches(patt, i);
            if (!matched) continue;
            for (int j = 0; j < this.excludedPatterns.length; ++j) {
                boolean excluded = this.matchesExclusion(patt, j);
                if (!excluded) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRegexpMethodPointcut that = (AbstractRegexpMethodPointcut)o;
        if (!Arrays.equals(this.excludedPatterns, that.excludedPatterns)) {
            return false;
        }
        return Arrays.equals(this.patterns, that.patterns);
    }

    public int hashCode() {
        int i;
        int result = 27;
        for (i = 0; i < this.patterns.length; ++i) {
            String pattern = this.patterns[i];
            result = 13 * result + pattern.hashCode();
        }
        for (i = 0; i < this.excludedPatterns.length; ++i) {
            String excludedPattern = this.excludedPatterns[i];
            result = 13 * result + excludedPattern.hashCode();
        }
        return result;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
        this.initPatternRepresentation(this.patterns);
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }
}

