/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.springframework.aop.TargetSource;
import org.springframework.util.Assert;

public class HotSwappableTargetSource
implements TargetSource,
Serializable {
    private Object target;

    public HotSwappableTargetSource(Object initialTarget) {
        Assert.notNull((Object)initialTarget, (String)"initialTarget is required");
        this.target = initialTarget;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public final boolean isStatic() {
        return false;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object target) {
    }

    public synchronized Object swap(Object newTarget) throws IllegalArgumentException {
        Assert.notNull((Object)newTarget, (String)"New target must not be null");
        Object old = this.target;
        this.target = newTarget;
        return old;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HotSwappableTargetSource)) {
            return false;
        }
        HotSwappableTargetSource otherTargetSource = (HotSwappableTargetSource)other;
        return this.target.equals(otherTargetSource.target);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return "HotSwappableTargetSource for target: " + this.target;
    }
}

