/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorResources;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springmodules.commons.validator.ValidatorFactory;
import org.xml.sax.SAXException;

public class DefaultValidatorFactory
implements ValidatorFactory,
InitializingBean {
    public static final String ERRORS_KEY = "org.springframework.validation.Errors";
    private static Log log = LogFactory.getLog((Class)(class$org$springmodules$commons$validator$DefaultValidatorFactory == null ? (class$org$springmodules$commons$validator$DefaultValidatorFactory = DefaultValidatorFactory.class$("org.springmodules.commons.validator.DefaultValidatorFactory")) : class$org$springmodules$commons$validator$DefaultValidatorFactory));
    private ValidatorResources validatorResources;
    static /* synthetic */ Class class$org$springmodules$commons$validator$DefaultValidatorFactory;

    public void afterPropertiesSet() throws Exception {
        if (this.validatorResources == null) {
            throw new FatalBeanException("Unable to locate validation configuration. Property [validationLocations] is required.");
        }
    }

    public void setValidationConfigLocations(Resource[] validationConfigLocations) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading validation configurations from [" + StringUtils.arrayToCommaDelimitedString((Object[])validationConfigLocations) + "]"));
        }
        try {
            InputStream[] inputStreams = new InputStream[validationConfigLocations.length];
            for (int i = 0; i < inputStreams.length; ++i) {
                inputStreams[i] = validationConfigLocations[i].getInputStream();
            }
            this.validatorResources = new ValidatorResources(inputStreams);
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read validation configuration due to IOException.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new FatalBeanException("Unable to parse validation configuration XML", (Throwable)e);
        }
    }

    public Validator getValidator(String beanName, Object bean, Errors errors) {
        Validator validator = new Validator(this.validatorResources, beanName);
        validator.setParameter(ERRORS_KEY, (Object)errors);
        validator.setParameter("java.lang.Object", bean);
        return validator;
    }

    public boolean hasRulesForBean(String beanName, Locale locale) {
        Form form = this.validatorResources.getForm(locale, beanName);
        return form != null;
    }

    public ValidatorResources getValidatorResources() {
        return this.validatorResources;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

