/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.webflow.Action;
import org.springframework.webflow.Flow;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.UnmodifiableAttributeMap;

public class ActionExecutionException
extends StateException {
    private Flow flow;
    private Action action;
    private UnmodifiableAttributeMap executionProperties;

    public ActionExecutionException(Flow flow, Action action, UnmodifiableAttributeMap executionProperties, Throwable cause) {
        this(null, action, executionProperties, "Exception thrown executing start " + action + " of flow '" + flow.getId() + "'", cause);
        this.flow = flow;
    }

    public ActionExecutionException(State state, Action action, UnmodifiableAttributeMap executionProperties, Throwable cause) {
        this(state, action, executionProperties, "Exception thrown executing " + action + " in state '" + state.getId() + "' of flow '" + state.getFlow().getId() + "'", cause);
    }

    public ActionExecutionException(State state, Action action, UnmodifiableAttributeMap executionProperties, String message, Throwable cause) {
        super(state, message, cause);
        this.action = action;
        this.executionProperties = executionProperties;
    }

    public Flow getFlow() {
        if (this.getState() != null) {
            return this.getState().getFlow();
        }
        return this.flow;
    }

    public Action getAction() {
        return this.action;
    }

    public UnmodifiableAttributeMap getExecutionProperties() {
        return this.executionProperties;
    }
}

