/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.webflow.Action;
import org.springframework.webflow.ActionExecutor;
import org.springframework.webflow.AnnotatedAction;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.StateException;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;

public class DecisionState
extends TransitionableState {
    private Action action;

    public DecisionState() {
    }

    public DecisionState(Flow flow, String stateId) throws IllegalArgumentException {
        super(flow, stateId);
    }

    public Action getAction() {
        return this.action;
    }

    public AnnotatedAction getAnnotatedAction() {
        if (this.action == null) {
            return null;
        }
        if (this.action instanceof AnnotatedAction) {
            return (AnnotatedAction)this.action;
        }
        return new AnnotatedAction(this.action);
    }

    public void setAction(Action action) {
        this.action = action;
    }

    protected ViewSelection doEnter(FlowExecutionControlContext context) throws StateException {
        Event event;
        if (this.action != null && (event = ActionExecutor.execute(this.action, context)) != null) {
            return context.signalEvent(event);
        }
        return this.getRequiredTransition(context).execute(this, context);
    }
}

