/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.StateException;
import org.springframework.webflow.StateExceptionHandler;
import org.springframework.webflow.ViewSelection;

public class StateExceptionHandlerSet {
    private List exceptionHandlers = new LinkedList();

    public boolean add(StateExceptionHandler exceptionHandler) {
        if (this.contains(exceptionHandler)) {
            return false;
        }
        return this.exceptionHandlers.add(exceptionHandler);
    }

    public boolean addAll(StateExceptionHandler[] exceptionHandlers) {
        if (exceptionHandlers == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < exceptionHandlers.length; ++i) {
            if (!this.add(exceptionHandlers[i]) || changed) continue;
            changed = true;
        }
        return changed;
    }

    public boolean contains(StateExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.contains(exceptionHandler);
    }

    public boolean remove(StateExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.remove(exceptionHandler);
    }

    public int size() {
        return this.exceptionHandlers.size();
    }

    public StateExceptionHandler[] toArray() {
        return this.exceptionHandlers.toArray(new StateExceptionHandler[this.exceptionHandlers.size()]);
    }

    public ViewSelection handleException(StateException exception, FlowExecutionControlContext context) throws StateException {
        Iterator it = this.exceptionHandlers.iterator();
        while (it.hasNext()) {
            StateExceptionHandler handler = (StateExceptionHandler)it.next();
            if (!handler.handles(exception)) continue;
            return handler.handle(exception, context);
        }
        throw exception;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("exceptionHandlers", (Object)this.exceptionHandlers).toString();
    }
}

