/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.NullViewSelector;
import org.springframework.webflow.StateException;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;

public class ViewState
extends TransitionableState {
    private ViewSelector viewSelector = NullViewSelector.INSTANCE;

    public ViewState() {
    }

    public ViewState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public ViewSelector getViewSelector() {
        return this.viewSelector;
    }

    public void setViewSelector(ViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    protected ViewSelection doEnter(FlowExecutionControlContext context) throws StateException {
        return this.selectView(context);
    }

    public ViewSelection selectView(FlowExecutionControlContext context) {
        ViewSelection selection = this.viewSelector.makeSelection(context);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Made view selection " + selection));
        }
        return selection;
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("viewSelector", (Object)this.viewSelector);
        super.appendToString(creator);
    }
}

