/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.webflow.Action;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.support.EventFactorySupport;

public abstract class AbstractAction
extends EventFactorySupport
implements Action,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void afterPropertiesSet() throws Exception {
        try {
            this.initAction();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Initialization of Action failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void initAction() throws Exception {
    }

    public final Event execute(RequestContext context) throws Exception {
        Event result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Action '" + this.getClass().getName() + "' beginning execution"));
        }
        if ((result = this.doPreExecute(context)) == null) {
            result = this.doExecute(context);
            if (this.logger.isDebugEnabled()) {
                if (result != null) {
                    this.logger.debug((Object)("Action '" + this.getClass().getName() + "' completed execution; result is '" + result.getId() + "'"));
                } else {
                    this.logger.debug((Object)("Action '" + this.getClass().getName() + "' completed execution; " + "returned result is [null]"));
                }
            }
            this.doPostExecute(context);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Action execution disallowed; pre-execute result is '" + result.getId() + "'"));
        }
        return result;
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        return null;
    }

    protected abstract Event doExecute(RequestContext var1) throws Exception;

    protected void doPostExecute(RequestContext context) throws Exception {
    }
}

