/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.util.Iterator;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.support.FlowVariable;

public class FlowVariableCreatingAction
extends AbstractAction {
    private Set variables = CollectionFactory.createLinkedSetIfPossible((int)3);

    public FlowVariableCreatingAction() {
    }

    public FlowVariableCreatingAction(FlowVariable variable) {
        this.addVariable(variable);
    }

    public FlowVariableCreatingAction(FlowVariable[] variables) {
        this.addVariables(variables);
    }

    public void addVariable(FlowVariable variable) {
        this.variables.add(variable);
    }

    public void addVariables(FlowVariable[] variables) {
        if (variables == null) {
            return;
        }
        for (int i = 0; i < variables.length; ++i) {
            this.addVariable(variables[i]);
        }
    }

    public FlowVariable[] getVariables() {
        return this.variables.toArray(new FlowVariable[0]);
    }

    protected Event doExecute(RequestContext context) throws Exception {
        this.createFlowVariables(context);
        return this.success();
    }

    protected void createFlowVariables(RequestContext context) {
        Iterator it = this.variables.iterator();
        while (it.hasNext()) {
            FlowVariable var = (FlowVariable)it.next();
            var.create(context);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("variables", (Object)this.getVariables()).toString();
    }
}

