/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.springframework.util.Assert;
import org.springframework.webflow.builder.FlowArtifactParameters;
import org.springframework.webflow.builder.FlowBuilder;

public class FlowAssembler {
    private FlowArtifactParameters flowParameters;
    private FlowBuilder flowBuilder;

    public FlowAssembler(String flowId, FlowBuilder flowBuilder) {
        this(new FlowArtifactParameters(flowId), flowBuilder);
    }

    public FlowAssembler(FlowArtifactParameters flowParameters, FlowBuilder flowBuilder) {
        this.setFlowParameters(flowParameters);
        this.setFlowBuilder(flowBuilder);
    }

    public FlowArtifactParameters getFlowParameters() {
        return this.flowParameters;
    }

    public void setFlowParameters(FlowArtifactParameters flowParameters) {
        this.flowParameters = flowParameters;
    }

    public FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    public void setFlowBuilder(FlowBuilder flowBuilder) {
        Assert.notNull((Object)flowBuilder, (String)"The flow builder is required");
        this.flowBuilder = flowBuilder;
    }

    public void assembleFlow() {
        this.flowBuilder.init(this.flowParameters);
        this.flowBuilder.buildStates();
        this.flowBuilder.buildExceptionHandlers();
        this.flowBuilder.buildPostProcess();
        this.flowBuilder.dispose();
    }
}

