/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.impl;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecutionListener;

public class FlowExecutionListeners {
    private FlowExecutionListener[] listeners;

    public FlowExecutionListeners() {
        this(null);
    }

    public FlowExecutionListeners(FlowExecutionListener[] listeners) {
        this.listeners = listeners != null ? listeners : new FlowExecutionListener[0];
    }

    public FlowExecutionListener[] getArray() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public void fireRequestSubmitted(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestSubmitted(context);
        }
    }

    public void fireRequestProcessed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].requestProcessed(context);
        }
    }

    public void fireSessionStarting(RequestContext context, State startState, AttributeMap input) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarting(context, startState, input);
        }
    }

    public void fireSessionStarted(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionStarted(context);
        }
    }

    public void fireEventSignaled(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].eventSignaled(context, context.getCurrentState());
        }
    }

    public void fireEventSignaled(RequestContext context, State state) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].eventSignaled(context, state);
        }
    }

    public void fireStateEntering(RequestContext context, State nextState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntering(context, nextState);
        }
    }

    public void fireStateEntered(RequestContext context, State previousState) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].stateEntered(context, previousState, context.getCurrentState());
        }
    }

    public void fireResumed(RequestContext context) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].resumed(context);
        }
    }

    public void firePaused(RequestContext context, ViewSelection selectedView) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].paused(context, selectedView);
        }
    }

    public void fireSessionEnding(RequestContext context, AttributeMap sessionOutput) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnding(context, sessionOutput);
        }
    }

    public void fireSessionEnded(RequestContext context, FlowSession endedSession, UnmodifiableAttributeMap sessionOutput) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].sessionEnded(context, endedSession, sessionOutput);
        }
    }
}

