/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.ContinuationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepositoryCreator;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public class ContinuationFlowExecutionRepositoryCreator
extends AbstractFlowExecutionRepositoryCreator {
    private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();
    private int maxContinuations = 25;

    public ContinuationFlowExecutionRepositoryCreator(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices);
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        this.continuationFactory = continuationFactory;
    }

    public void setMaxContinuations(int maxContinuations) {
        this.maxContinuations = maxContinuations;
    }

    public FlowExecutionRepository createRepository() {
        ContinuationFlowExecutionRepository repository = new ContinuationFlowExecutionRepository(this.getRepositoryServices());
        repository.setContinuationFactory(this.continuationFactory);
        repository.setMaxContinuations(this.maxContinuations);
        return repository;
    }

    public FlowExecutionRepository rehydrateRepository(FlowExecutionRepository repository) {
        ContinuationFlowExecutionRepository impl = (ContinuationFlowExecutionRepository)repository;
        impl.setRepositoryServices(this.getRepositoryServices());
        impl.setContinuationFactory(this.continuationFactory);
        return impl;
    }
}

