/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public abstract class AbstractFlowExecutionRepository
implements FlowExecutionRepository {
    private transient FlowExecutionRepositoryServices repositoryServices;

    protected AbstractFlowExecutionRepository() {
    }

    public AbstractFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        this.setRepositoryServices(repositoryServices);
    }

    public FlowExecutionRepositoryServices getRepositoryServices() {
        return this.repositoryServices;
    }

    public void setRepositoryServices(FlowExecutionRepositoryServices repositoryServices) {
        Assert.notNull((Object)repositoryServices, (String)"The repository services instance is required");
        this.repositoryServices = repositoryServices;
    }

    public FlowExecution createFlowExecution(String flowId) {
        Flow flow = this.repositoryServices.getFlowLocator().getFlow(flowId);
        return new FlowExecutionImpl(flow, this.repositoryServices.getListenerLoader().getListeners(flow));
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution) {
        return new FlowExecutionKey(this.generateId(), this.generateId());
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution, Serializable conversationId) {
        return new FlowExecutionKey(conversationId, this.generateId());
    }

    protected FlowExecution rehydrate(FlowExecution flowExecution) {
        ((FlowExecutionImpl)flowExecution).rehydrate(this.repositoryServices.getFlowLocator(), this.repositoryServices.getListenerLoader());
        return flowExecution;
    }

    protected Serializable generateId() {
        return this.repositoryServices.getUidGenerator().generateId();
    }
}

