/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.CannotContinueConversationException;
import org.springframework.webflow.execution.repository.ConversationLock;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.NoSuchConversationException;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.ConversationLockFactory;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;

public class SimpleFlowExecutionRepository
extends AbstractFlowExecutionRepository
implements Serializable {
    private static final long serialVersionUID = -8138465280185005691L;
    private Map flowExecutionEntries = new HashMap(128);

    public SimpleFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices);
    }

    public ConversationLock getLock(Serializable conversationId) {
        return this.getFlowExecutionEntry(conversationId).getLock();
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        FlowExecutionEntry entry = this.getFlowExecutionEntry(key.getConversationId());
        if (!key.getContinuationId().equals(entry.getContinuationId())) {
            throw new CannotContinueConversationException(key, "The continuation id '" + key.getContinuationId() + "' associated with conversation '" + key.getConversationId() + "' is invalid.  This will happen when accessing browser history " + "(typically via the back button) that references a previously used continuation id, " + "as this simple repository implementation does not support multiple continuations.  " + "Consider using another repository implementation or " + "restrict use of the browser back button.");
        }
        return this.rehydrate(entry.getFlowExecution());
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
        FlowExecutionEntry entry = (FlowExecutionEntry)this.flowExecutionEntries.get(key.getConversationId());
        if (entry != null) {
            entry.setContinuationId(key.getContinuationId());
        } else {
            this.flowExecutionEntries.put(key.getConversationId(), new FlowExecutionEntry(key.getContinuationId(), flowExecution));
        }
    }

    public FlowExecutionKey getCurrentFlowExecutionKey(Serializable conversationId) throws FlowExecutionRepositoryException {
        return new FlowExecutionKey(conversationId, this.getFlowExecutionEntry(conversationId).getContinuationId());
    }

    public ViewSelection getCurrentViewSelection(Serializable conversationId) {
        return this.getFlowExecutionEntry(conversationId).getCurrentViewSelection();
    }

    public void setCurrentViewSelection(Serializable conversationId, ViewSelection viewSelection) {
        this.getFlowExecutionEntry(conversationId).setCurrentViewSelection(viewSelection);
    }

    public void invalidateConversation(Serializable conversationId) {
        this.flowExecutionEntries.remove(conversationId);
    }

    private FlowExecutionEntry getFlowExecutionEntry(Serializable conversationId) {
        FlowExecutionEntry entry = (FlowExecutionEntry)this.flowExecutionEntries.get(conversationId);
        if (entry == null) {
            throw new NoSuchConversationException(conversationId);
        }
        return entry;
    }

    protected static class FlowExecutionEntry
    implements Serializable {
        private Serializable continuationId;
        private ConversationLock lock;
        private FlowExecution flowExecution;
        private ViewSelection currentViewSelection = ViewSelection.NULL_VIEW;

        public FlowExecutionEntry(Serializable id, FlowExecution flowExecution) {
            this.continuationId = id;
            this.lock = this.createLock();
            this.flowExecution = flowExecution;
        }

        public Serializable getContinuationId() {
            return this.continuationId;
        }

        public void setContinuationId(Serializable continuationId) {
            this.continuationId = continuationId;
        }

        public ConversationLock getLock() {
            return this.lock;
        }

        public FlowExecution getFlowExecution() {
            return this.flowExecution;
        }

        public ViewSelection getCurrentViewSelection() {
            return this.currentViewSelection;
        }

        public void setCurrentViewSelection(ViewSelection viewSelection) {
            this.currentViewSelection = viewSelection;
        }

        protected ConversationLock createLock() {
            return ConversationLockFactory.createLock();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("id", (Object)this.continuationId).append("flowExecution", (Object)this.flowExecution).toString();
        }
    }
}

