/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.ConversationRedirect;
import org.springframework.webflow.support.ExternalRedirect;
import org.springframework.webflow.support.FlowRedirect;

public class ResponseInstruction
implements Serializable {
    private static final long serialVersionUID = -3787181142379347131L;
    private final FlowExecutionKey flowExecutionKey;
    private final transient FlowExecutionContext flowExecutionContext;
    private final ViewSelection viewSelection;

    public ResponseInstruction(FlowExecutionKey flowExecutionKey, FlowExecutionContext flowExecutionContext, ViewSelection viewSelection) {
        this.flowExecutionKey = flowExecutionKey;
        this.flowExecutionContext = flowExecutionContext;
        this.viewSelection = viewSelection;
    }

    public ResponseInstruction(FlowExecutionContext flowExecutionContext, ViewSelection viewSelection) {
        this.flowExecutionKey = null;
        this.flowExecutionContext = flowExecutionContext;
        this.viewSelection = viewSelection;
    }

    public FlowExecutionKey getFlowExecutionKey() {
        return this.flowExecutionKey;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    public ViewSelection getViewSelection() {
        return this.viewSelection;
    }

    public boolean isNull() {
        return this.viewSelection == ViewSelection.NULL_VIEW;
    }

    public boolean isApplicationView() {
        return this.viewSelection instanceof ApplicationView;
    }

    public boolean isActiveView() {
        return this.isApplicationView() && this.flowExecutionContext.isActive();
    }

    public boolean isConfirmationView() {
        return this.isApplicationView() && !this.flowExecutionContext.isActive();
    }

    public boolean isConversationRedirect() {
        return this.viewSelection instanceof ConversationRedirect;
    }

    public boolean isExternalRedirect() {
        return this.viewSelection instanceof ExternalRedirect;
    }

    public boolean isFlowRedirect() {
        return this.viewSelection instanceof FlowRedirect;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowExecutionKey", (Object)this.flowExecutionKey).append("flowExecutionContext", (Object)this.flowExecutionContext).append("viewSelection", (Object)this.viewSelection).toString();
    }
}

