/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.io.Serializable;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.execution.FlowLocator;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.support.SimpleFlowExecutionRepositoryFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.FlowRedirect;

public class PortletFlowController
extends AbstractController
implements InitializingBean {
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor argumentExtractor = new FlowExecutorArgumentExtractor();

    public PortletFlowController() {
        this.initDefaults();
    }

    protected void initDefaults() {
        this.setCacheSeconds(0);
    }

    public void setFlowLocator(FlowLocator flowLocator) {
        this.flowExecutor = new FlowExecutorImpl(new SimpleFlowExecutionRepositoryFactory(flowLocator));
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public void setArgumentExtractor(FlowExecutorArgumentExtractor parameterExtractor) {
        this.argumentExtractor = parameterExtractor;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentExtractor.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        Serializable conversationId = this.argumentExtractor.extractConversationId(context);
        if (conversationId != null) {
            ResponseInstruction responseInstruction = this.getCachedResponseInstruction((PortletRequest)request, this.getConversationAttributeName(conversationId));
            if (responseInstruction == null) {
                responseInstruction = this.flowExecutor.getCurrentResponseInstruction(conversationId, context);
            }
            return this.toModelAndView(responseInstruction);
        }
        String flowId = this.argumentExtractor.extractFlowId(context);
        ResponseInstruction responseInstruction = this.flowExecutor.launch(flowId, context);
        return this.toModelAndView(responseInstruction);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        FlowExecutionKey flowExecutionKey;
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        String eventId = this.argumentExtractor.extractEventId(context);
        ResponseInstruction responseInstruction = this.flowExecutor.signalEvent(eventId, flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context), context);
        if (responseInstruction.isApplicationView() || responseInstruction.isConversationRedirect()) {
            Serializable conversationId = flowExecutionKey.getConversationId();
            response.setRenderParameter(this.argumentExtractor.getConversationIdParameterName(), String.valueOf(conversationId));
            if (responseInstruction.isConfirmationView()) {
                this.cacheResponseInstruction((PortletRequest)request, responseInstruction, conversationId);
            }
        } else if (responseInstruction.isFlowRedirect()) {
            String flowId = ((FlowRedirect)responseInstruction.getViewSelection()).getFlowId();
            response.setRenderParameter(this.argumentExtractor.getFlowIdParameterName(), flowId);
        } else {
            throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
        }
    }

    private ResponseInstruction getCachedResponseInstruction(PortletRequest request, String attributeName) {
        PortletSession session = request.getPortletSession(false);
        ResponseInstruction response = null;
        if (session != null && (response = (ResponseInstruction)session.getAttribute(attributeName)) != null) {
            session.removeAttribute(attributeName);
        }
        return response;
    }

    protected ModelAndView toModelAndView(ResponseInstruction response) {
        if (response.isApplicationView()) {
            ApplicationView forward = (ApplicationView)response.getViewSelection();
            HashMap model = new HashMap(forward.getModel());
            this.argumentExtractor.put(response.getFlowExecutionKey(), model);
            this.argumentExtractor.put(response.getFlowExecutionContext(), model);
            return new ModelAndView(forward.getViewName(), model);
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }

    private void cacheResponseInstruction(PortletRequest request, ResponseInstruction response, Serializable conversationId) {
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            session.setAttribute(this.getConversationAttributeName(conversationId), (Object)response);
        }
    }

    private String getConversationAttributeName(Serializable conversationId) {
        return "responseInstruction." + conversationId;
    }
}

