/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ObjectUtils;
import org.springframework.webflow.ViewSelection;

public final class ApplicationView
extends ViewSelection {
    private final String viewName;
    private final Map model;

    public ApplicationView(String viewName, Map model) {
        if (model == null) {
            model = Collections.EMPTY_MAP;
        }
        this.viewName = viewName;
        this.model = model;
    }

    public String getViewName() {
        return this.viewName;
    }

    public Map getModel() {
        return Collections.unmodifiableMap(this.model);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApplicationView)) {
            return false;
        }
        ApplicationView other = (ApplicationView)o;
        return ObjectUtils.nullSafeEquals((Object)this.viewName, (Object)other.viewName) && ((Object)this.model).equals(other.model);
    }

    public int hashCode() {
        return (this.viewName != null ? this.viewName.hashCode() : 0) + ((Object)this.model).hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("viewName", (Object)this.viewName).append("model", (Object)this.model).toString();
    }
}

