/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import org.springframework.beans.BeanUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;

public class FlowVariable
implements Serializable {
    private String name;
    private Class type;

    public FlowVariable(String name, Class type) {
        Assert.notNull((Object)name, (String)"The variable name is required");
        Assert.notNull((Object)type, (String)"The variable type is required");
        this.name = name;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowVariable)) {
            return false;
        }
        FlowVariable other = (FlowVariable)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void create(RequestContext context) {
        context.getFlowScope().put(this.name, BeanUtils.instantiateClass((Class)this.type));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("type", (Object)this.type).toString();
    }
}

