/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.State;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockRequestContext;

public class MockFlowExecutionControlContext
extends MockRequestContext
implements FlowExecutionControlContext {
    public MockFlowExecutionControlContext(Flow rootFlow) {
        this.getMockFlowExecutionContext().setRootFlow(rootFlow);
    }

    public ViewSelection start(Flow flow, State startState, AttributeMap input) throws IllegalStateException {
        this.getMockFlowExecutionContext().setActiveSession(new MockFlowSession(flow, input));
        ViewSelection selectedView = flow.start(startState, this);
        this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.PAUSED);
        return selectedView;
    }

    public ViewSelection signalEvent(Event event) {
        this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.ACTIVE);
        ViewSelection selectedView = this.getActiveFlow().onEvent(event, this);
        this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.PAUSED);
        return selectedView;
    }

    public FlowSession endActiveFlowSession(AttributeMap sessionOutput) throws IllegalStateException {
        MockFlowSession endingSession = this.getMockFlowExecutionContext().getMockActiveSession();
        endingSession.getFlow().end(this, sessionOutput);
        endingSession.setStatus(FlowSessionStatus.ENDED);
        this.getMockFlowExecutionContext().setActiveSession(null);
        return endingSession;
    }

    public void setCurrentState(State state) {
        this.getMockFlowExecutionContext().getMockActiveSession().setState(state);
        State previousState = this.getCurrentState();
        if (previousState == null) {
            this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.ACTIVE);
        }
    }
}

