/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.Configuration;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.ExecutionContext;
import uk.ltd.getahead.dwr.Factory;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.util.Logger;
import uk.ltd.getahead.dwr.util.ServletLoggingOutput;

public class DWRServlet
extends HttpServlet {
    protected Processor processor;
    public static final String PACKAGE = "/uk/ltd/getahead/dwr/";
    protected static final String INIT_SKIP_DEFAULT = "skipDefaultConfig";
    protected static final String INIT_CONFIG = "config";
    protected static final String INIT_DEBUG = "debug";
    protected static final String INIT_LOGLEVEL = "logLevel";
    protected static final String INIT_IMPL_PREFIX = "uk.ltd.getahead.dwr";
    protected static final String FILE_DWR_XML = "dwr.xml";
    protected static final String DEFAULT_DWR_XML = "/WEB-INF/dwr.xml";
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$DWRServlet == null ? (class$uk$ltd$getahead$dwr$DWRServlet = DWRServlet.class$("uk.ltd.getahead.dwr.DWRServlet")) : class$uk$ltd$getahead$dwr$DWRServlet);
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$AccessControl;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$Configuration;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$ConverterManager;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$CreatorManager;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$Processor;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$ExecutionContext;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$DWRServlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String skip;
            ExecutionContext.setExecutionContext(null, null, this.getServletConfig(), this.getServletContext());
            ServletLoggingOutput.setExecutionContext(this);
            String logLevel = config.getInitParameter(INIT_LOGLEVEL);
            if (logLevel != null) {
                ServletLoggingOutput.setLevel(logLevel);
            }
            Factory factory = new Factory();
            factory.setImplementation((class$uk$ltd$getahead$dwr$AccessControl == null ? (class$uk$ltd$getahead$dwr$AccessControl = DWRServlet.class$("uk.ltd.getahead.dwr.AccessControl")) : class$uk$ltd$getahead$dwr$AccessControl).getName(), "uk.ltd.getahead.dwr.impl.DefaultAccessControl");
            factory.setImplementation((class$uk$ltd$getahead$dwr$Configuration == null ? (class$uk$ltd$getahead$dwr$Configuration = DWRServlet.class$("uk.ltd.getahead.dwr.Configuration")) : class$uk$ltd$getahead$dwr$Configuration).getName(), "uk.ltd.getahead.dwr.impl.DefaultConfiguration");
            factory.setImplementation((class$uk$ltd$getahead$dwr$ConverterManager == null ? (class$uk$ltd$getahead$dwr$ConverterManager = DWRServlet.class$("uk.ltd.getahead.dwr.ConverterManager")) : class$uk$ltd$getahead$dwr$ConverterManager).getName(), "uk.ltd.getahead.dwr.impl.DefaultConverterManager");
            factory.setImplementation((class$uk$ltd$getahead$dwr$CreatorManager == null ? (class$uk$ltd$getahead$dwr$CreatorManager = DWRServlet.class$("uk.ltd.getahead.dwr.CreatorManager")) : class$uk$ltd$getahead$dwr$CreatorManager).getName(), "uk.ltd.getahead.dwr.impl.DefaultCreatorManager");
            factory.setImplementation((class$uk$ltd$getahead$dwr$Processor == null ? (class$uk$ltd$getahead$dwr$Processor = DWRServlet.class$("uk.ltd.getahead.dwr.Processor")) : class$uk$ltd$getahead$dwr$Processor).getName(), "uk.ltd.getahead.dwr.impl.DefaultProcessor");
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (!name.startsWith(INIT_IMPL_PREFIX)) continue;
                String value = config.getInitParameter(name);
                try {
                    factory.setImplementation(name, value);
                }
                catch (Exception ex) {
                    log.fatal("Invalid implmentation parameter: " + name + "=" + value, ex);
                    throw new ServletException(Messages.getString("DWRServlet.ExecutionContextInit", name, value), (Throwable)ex);
                }
            }
            factory.configurationFinished();
            String execCxName = config.getInitParameter((class$uk$ltd$getahead$dwr$ExecutionContext == null ? (class$uk$ltd$getahead$dwr$ExecutionContext = DWRServlet.class$("uk.ltd.getahead.dwr.ExecutionContext")) : class$uk$ltd$getahead$dwr$ExecutionContext).getName());
            if (execCxName != null) {
                try {
                    Class<?> type = Class.forName(execCxName);
                    ExecutionContext.setImplementation(type);
                }
                catch (Exception ex) {
                    log.fatal("Invalid executionContext parameter", ex);
                    throw new ServletException(Messages.getString("DWRServlet.ExecutionContextInit", execCxName, ex), (Throwable)ex);
                }
            }
            String debugStr = config.getInitParameter(INIT_DEBUG);
            boolean debug = Boolean.valueOf(debugStr);
            CreatorManager creatorManager = (CreatorManager)factory.getBean(class$uk$ltd$getahead$dwr$CreatorManager == null ? (class$uk$ltd$getahead$dwr$CreatorManager = DWRServlet.class$("uk.ltd.getahead.dwr.CreatorManager")) : class$uk$ltd$getahead$dwr$CreatorManager);
            creatorManager.setDebug(debug);
            Configuration configuration = (Configuration)factory.getBean(class$uk$ltd$getahead$dwr$Configuration == null ? (class$uk$ltd$getahead$dwr$Configuration = DWRServlet.class$("uk.ltd.getahead.dwr.Configuration")) : class$uk$ltd$getahead$dwr$Configuration);
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(FILE_DWR_XML);
            try {
                configuration.addConfig(in);
            }
            catch (Exception ex) {
                log.fatal("Failed to load system config file from dwr.jar", ex);
                throw new ServletException(Messages.getString("DWRServlet.SystemConfigError"), (Throwable)ex);
            }
            en = config.getInitParameterNames();
            boolean foundConfig = false;
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (!name.startsWith(INIT_CONFIG)) continue;
                foundConfig = true;
                String configFile = config.getInitParameter(name);
                this.readFile(configFile, configuration);
            }
            if (!foundConfig && !Boolean.valueOf(skip = config.getInitParameter(INIT_SKIP_DEFAULT)).booleanValue()) {
                this.readFile(DEFAULT_DWR_XML, configuration);
            }
            this.processor = (Processor)factory.getBean(class$uk$ltd$getahead$dwr$Processor == null ? (class$uk$ltd$getahead$dwr$Processor = DWRServlet.class$("uk.ltd.getahead.dwr.Processor")) : class$uk$ltd$getahead$dwr$Processor);
        }
        finally {
            ExecutionContext.unset();
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            ExecutionContext.setExecutionContext(req, resp, this.getServletConfig(), this.getServletContext());
            ServletLoggingOutput.setExecutionContext(this);
            this.processor.handle(req, resp);
        }
        finally {
            ExecutionContext.unset();
            ServletLoggingOutput.unsetExecutionContext();
        }
    }

    protected void readFile(String configFile, Configuration configuration) throws ServletException {
        try {
            InputStream in = this.getServletContext().getResourceAsStream(configFile);
            if (in == null) {
                log.error("Missing config file: " + configFile);
            } else {
                configuration.addConfig(in);
            }
        }
        catch (Exception ex) {
            throw new ServletException(Messages.getString("DWRServlet.ConfigError", configFile), (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

