/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class CollectionConverter
implements Converter {
    private ConverterManager config = null;
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$convert$CollectionConverter == null ? (class$uk$ltd$getahead$dwr$convert$CollectionConverter = CollectionConverter.class$("uk.ltd.getahead.dwr.convert.CollectionConverter")) : class$uk$ltd$getahead$dwr$convert$CollectionConverter);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$convert$CollectionConverter;

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingOpener", "["));
        }
        if (!value.endsWith("]")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingCloser", "]"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Method method = inctx.getCurrentMethod();
            int paramNum = inctx.getCurrentParameterNum();
            Class subtype = this.config.getExtraTypeInfo(method, paramNum, 0);
            if (subtype == null) {
                log.warn("Missing type info for " + method.getName() + "(), param=" + paramNum + ". Assuming this is a collection of Strings. Please add to <signatures> in dwr.xml");
                subtype = class$java$lang$String == null ? (class$java$lang$String = CollectionConverter.class$("java.lang.String")) : class$java$lang$String;
            } else {
                log.debug("Using extra type info for " + method.getName() + "(), param=" + paramNum + " of " + subtype);
            }
            Collection<Object> col = null;
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = CollectionConverter.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else if ((class$java$util$Set == null ? (class$java$util$Set = CollectionConverter.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(paramType)) {
                col = new HashSet();
            } else if ((class$java$util$List == null ? (class$java$util$List = CollectionConverter.class$("java.util.List")) : class$java$util$List).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else {
                throw new ConversionException(Messages.getString("CollectionConverter.ConvertError") + paramType.getName());
            }
            inctx.addConverted(iv, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = LocalUtil.splitInbound(token);
                InboundVariable nested = new InboundVariable(iv.getLookup(), split[0], split[1]);
                Object output = this.config.convertInbound(subtype, nested, inctx);
                col.add(output);
            }
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = CollectionConverter.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        Iterator it = null;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new ConversionException(Messages.getString("CollectionConverter.ConvertFailed", data.getClass().getName()));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("var " + varname + " = new Array();");
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            OutboundVariable nested = this.config.convertOutbound(element, outctx);
            buffer.append(nested.getInitCode());
            buffer.append(varname);
            buffer.append('[');
            buffer.append(i);
            buffer.append("] = ");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
            ++i;
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

