/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Configuration;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.impl.DTDEntityResolver;
import uk.ltd.getahead.dwr.impl.SignatureParser;
import uk.ltd.getahead.dwr.util.LogErrorHandler;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultConfiguration
implements Configuration {
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$DefaultConfiguration == null ? (class$uk$ltd$getahead$dwr$impl$DefaultConfiguration = DefaultConfiguration.class$("uk.ltd.getahead.dwr.impl.DefaultConfiguration")) : class$uk$ltd$getahead$dwr$impl$DefaultConfiguration);
    private ConverterManager converterManager = null;
    private CreatorManager creatorManager = null;
    private AccessControl accessControl = null;
    private static final String ELEMENT_INIT = "init";
    private static final String ELEMENT_ALLOW = "allow";
    private static final String ELEMENT_CREATE = "create";
    private static final String ELEMENT_CONVERT = "convert";
    private static final String ELEMENT_PARAM = "param";
    private static final String ELEMENT_INCLUDE = "include";
    private static final String ELEMENT_EXCLUDE = "exclude";
    private static final String ELEMENT_PARAMETER = "parameter";
    private static final String ELEMENT_AUTH = "auth";
    private static final String ELEMENT_SIGNATURES = "signatures";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CONVERTER = "converter";
    private static final String ATTRIBUTE_MATCH = "match";
    private static final String ATTRIBUTE_JAVASCRIPT = "javascript";
    private static final String ATTRIBUTE_CREATOR = "creator";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_ROLE = "role";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_TYPE = "type";
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$DefaultConfiguration;

    public void addConfig(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new DTDEntityResolver());
        db.setErrorHandler(new LogErrorHandler());
        Document doc = db.parse(in);
        this.addConfig(doc);
    }

    public void addConfig(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList rootChildren = root.getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node node = rootChildren.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            if (child.getNodeName().equals(ELEMENT_INIT)) {
                this.loadInits(child);
                continue;
            }
            if (child.getNodeName().equals(ELEMENT_ALLOW)) {
                this.loadAllows(child);
                continue;
            }
            if (!child.getNodeName().equals(ELEMENT_SIGNATURES)) continue;
            this.loadSignature(child);
        }
    }

    private void loadInits(Element child) {
        NodeList inits = child.getChildNodes();
        for (int j = 0; j < inits.getLength(); ++j) {
            if (inits.item(j).getNodeType() != 1) continue;
            Element initer = (Element)inits.item(j);
            if (initer.getNodeName().equals(ATTRIBUTE_CREATOR)) {
                this.loadCreator(initer);
                continue;
            }
            if (!initer.getNodeName().equals(ATTRIBUTE_CONVERTER)) continue;
            this.loadConverter(initer);
        }
    }

    private void loadCreator(Element initer) {
        String id = initer.getAttribute(ATTRIBUTE_ID);
        String classname = initer.getAttribute(ATTRIBUTE_CLASS);
        try {
            Class<?> clazz = Class.forName(classname);
            this.creatorManager.addCreatorType(id, clazz);
        }
        catch (NoClassDefFoundError ex) {
            log.info("Missing classdef for creator '" + id + "'. Failed to load " + classname + ". Cause: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            log.info("Missing class for creator '" + id + "'. Failed to load " + classname + ". Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.warn("Failed to load creator '" + id + "', classname=" + classname + ": ", ex);
        }
    }

    private void loadConverter(Element initer) {
        String id = initer.getAttribute(ATTRIBUTE_ID);
        String classname = initer.getAttribute(ATTRIBUTE_CLASS);
        try {
            Class<?> clazz = Class.forName(classname);
            this.converterManager.addConverterType(id, clazz);
        }
        catch (NoClassDefFoundError ex) {
            log.info("Missing classdef for converter '" + id + "'. Failed to load " + classname + ". Cause: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            log.info("Missing class for converter '" + id + "'. Failed to load " + classname + ". Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.warn("Failed to load converter '" + id + "', classname=" + classname + ": " + ex);
        }
    }

    private void loadAllows(Element child) {
        NodeList allows = child.getChildNodes();
        for (int j = 0; j < allows.getLength(); ++j) {
            if (allows.item(j).getNodeType() != 1) continue;
            Element allower = (Element)allows.item(j);
            if (allower.getNodeName().equals(ELEMENT_CREATE)) {
                this.loadCreate(allower);
                continue;
            }
            if (!allower.getNodeName().equals(ELEMENT_CONVERT)) continue;
            this.loadConvert(allower);
        }
    }

    private void loadConvert(Element allower) {
        String match = allower.getAttribute(ATTRIBUTE_MATCH);
        String type = allower.getAttribute(ATTRIBUTE_CONVERTER);
        try {
            Map params = DefaultConfiguration.createSettingMap(allower);
            this.converterManager.addConverter(match, type, params);
        }
        catch (NoClassDefFoundError ex) {
            log.info("Missing class for convertor '" + type + "'. (match='" + match + "'). Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Failed to add convertor: match=" + match + ", type=" + type, ex);
        }
    }

    private void loadCreate(Element allower) {
        String type = allower.getAttribute(ATTRIBUTE_CREATOR);
        String javascript = allower.getAttribute(ATTRIBUTE_JAVASCRIPT);
        if (type.equals("session") || type.equals("static")) {
            log.error("The 'session' and 'static' creators are deprecated. Use the 'new' creator");
            log.error("  For more information see the DWR website");
            type = "new";
            if (type.equals("session")) {
                allower.setAttribute("scope", "session");
            }
        }
        try {
            Map params = DefaultConfiguration.createSettingMap(allower);
            this.creatorManager.addCreator(type, javascript, params);
            this.processPermissions(javascript, allower);
            this.processAuth(javascript, allower);
            this.processParameters(javascript, allower);
        }
        catch (NoClassDefFoundError ex) {
            log.info("Missing class for creator '" + type + "'. (javascript='" + javascript + "'). Cause: " + ex.getMessage());
        }
        catch (Exception ex) {
            log.error("Failed to add creator: type=" + type + ", javascript=" + javascript, ex);
        }
    }

    private static Map createSettingMap(Element parent) {
        HashMap<String, String> params = new HashMap<String, String>();
        NamedNodeMap attrs = parent.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node = attrs.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            params.put(name, value);
        }
        NodeList locNodes = parent.getElementsByTagName(ELEMENT_PARAM);
        for (int i = 0; i < locNodes.getLength(); ++i) {
            Element element = (Element)locNodes.item(i);
            String name = element.getAttribute(ATTRIBUTE_NAME);
            if (name == null) continue;
            String value = element.getAttribute(ATTRIBUTE_VALUE);
            if (value == null || value.length() == 0) {
                StringBuffer buffer = new StringBuffer();
                NodeList textNodes = element.getChildNodes();
                for (int j = 0; j < textNodes.getLength(); ++j) {
                    buffer.append(textNodes.item(j).getNodeValue());
                }
                value = buffer.toString();
            }
            params.put(name, value);
        }
        return params;
    }

    private void processPermissions(String javascript, Element parent) {
        NodeList incNodes = parent.getElementsByTagName(ELEMENT_INCLUDE);
        for (int i = 0; i < incNodes.getLength(); ++i) {
            Element include = (Element)incNodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            this.accessControl.addIncludeRule(javascript, method);
        }
        NodeList excNodes = parent.getElementsByTagName(ELEMENT_EXCLUDE);
        for (int i = 0; i < excNodes.getLength(); ++i) {
            Element include = (Element)excNodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            this.accessControl.addExcludeRule(javascript, method);
        }
    }

    private void processParameters(String javascript, Element parent) throws ClassNotFoundException {
        NodeList nodes = parent.getElementsByTagName(ELEMENT_PARAMETER);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element include = (Element)nodes.item(i);
            String methodName = include.getAttribute(ATTRIBUTE_METHOD);
            Creator creator = this.creatorManager.getCreator(javascript);
            Class dest = creator.getType();
            Method method = null;
            Method[] methods = dest.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method test = methods[j];
                if (!test.getName().equals(methodName)) continue;
                if (method == null) {
                    method = test;
                    continue;
                }
                log.warn("Setting extra type info to overloaded methods may fail with <parameter .../>");
            }
            if (method == null) {
                log.error("Unable to find method called: " + methodName + " on type: " + dest.getName() + " from creator: " + javascript);
                continue;
            }
            String number = include.getAttribute(ATTRIBUTE_NUMBER);
            int paramNo = Integer.parseInt(number);
            String types = include.getAttribute(ATTRIBUTE_TYPE);
            StringTokenizer st = new StringTokenizer(types, ",");
            int j = 0;
            while (st.hasMoreTokens()) {
                String type = st.nextToken();
                Class<?> clazz = Class.forName(type.trim());
                this.converterManager.setExtraTypeInfo(method, paramNo, j++, clazz);
            }
        }
    }

    private void processAuth(String javascript, Element parent) {
        NodeList nodes = parent.getElementsByTagName(ELEMENT_AUTH);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element include = (Element)nodes.item(i);
            String method = include.getAttribute(ATTRIBUTE_METHOD);
            String role = include.getAttribute(ATTRIBUTE_ROLE);
            this.accessControl.addRoleRestriction(javascript, method, role);
        }
    }

    private void loadSignature(Element element) {
        StringBuffer sigtext = new StringBuffer();
        element.normalize();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != 3 && type != 4) {
                log.warn("Ignoring illegal node type: " + type);
                continue;
            }
            sigtext.append(node.getNodeValue());
        }
        SignatureParser sigp = new SignatureParser(this.converterManager);
        sigp.parse(sigtext.toString());
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public CreatorManager getCreatorManager() {
        return this.creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

