/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;

public class MessageListenerAdapter
implements MessageListener,
SessionAwareMessageListener {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";
    private Destination defaultResponseDestination;
    private MessageConverter messageConverter;

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter());
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)"Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setDefaultResponseDestination(Destination defaultResponseDestination) {
        this.defaultResponseDestination = defaultResponseDestination;
    }

    protected Destination getDefaultResponseDestination() {
        return this.defaultResponseDestination;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, null);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    public void onMessage(Message message, Session session) throws JMSException {
        Object convertedMessage = this.extractMessage(message);
        String methodName = this.getListenerMethodName(message, convertedMessage);
        if (methodName == null) {
            throw new java.lang.IllegalStateException("No listener method for message [" + convertedMessage + "] - specify a 'defaultListenerMethod' or override 'getListenerMethodName'");
        }
        Object result = this.invokeListenerMethod(methodName, convertedMessage);
        if (result != null) {
            this.handleResult(result, message, session);
        } else {
            this.logger.debug((Object)"No result object given - no result to handle");
        }
    }

    protected Object extractMessage(Message message) throws JMSException {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        return message;
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) throws JMSException {
        String listenerMethod = this.getDefaultListenerMethod();
        if (listenerMethod == null) {
            throw new IllegalStateException("No default listener method specified - either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method");
        }
        return listenerMethod;
    }

    protected Object invokeListenerMethod(String methodName, Object message) throws JMSException {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(new Object[]{message});
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            throw new ListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with message [" + message + "]", ex);
        }
    }

    protected void handleResult(Object result, Message request, Session session) throws JMSException {
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listener method returned result [" + result + "] - generating response message for it"));
            }
            Message response = this.buildMessage(session, result);
            this.postProcessResponse(request, response);
            Destination destination = this.getResponseDestination(request, response);
            this.sendResponse(session, destination, response);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listener method returned result [" + result + "] - not generating response message for it because of no JMS Session given"));
        }
    }

    protected Message buildMessage(Session session, Object result) throws JMSException {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.toMessage(result, session);
        }
        if (!(result instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (Message)result;
    }

    protected void postProcessResponse(Message request, Message response) throws JMSException {
        response.setJMSCorrelationID(request.getJMSCorrelationID());
    }

    protected Destination getResponseDestination(Message request, Message response) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.getDefaultResponseDestination()) == null) {
            throw new InvalidDestinationException("Cannot determine response destination - request message does not contain reply-to destination, and no default response destination set");
        }
        return replyTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Session session, Destination destination, Message response) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        try {
            this.postProcessProducer(producer, response);
            producer.send(response);
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void postProcessProducer(MessageProducer producer, Message response) throws JMSException {
    }
}

