/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;

public class CoolMenuDisplayer
extends MessageResourcesMenuDisplayer {
    private static MessageFormat menuMessage = new MessageFormat("oCMenu.makeMenu(''{0}'',''{1}'',''{2}'',''{3}'',''{4}'','''','''',''{5}'',''{6}'',{7},{8},{9},");
    private static final String SCRIPT_START = "<script type=\"text/javascript\">\n";
    private static final String SCRIPT_END = "</script>\n";
    private static final String END_STATEMENT = "\noCMenu.makeStyle(); oCMenu.construct()\n";
    private static final String TOP_IMAGE = "cmTopMenuImage";
    private static final String SUB_IMAGE = "cmSubMenuImage";
    private static final String BGCOL_ON = "cmBGColorOn";
    private static final String BGCOL_OFF = "cmBGColorOff";
    private static final String TXTCOL = "cmTxtColor";
    private static final String HOVER = "cmHoverColor";
    private static final String DIS_BGCOL_ON = "cmDisBGColorOn";
    private static final String DIS_BGCOL_OFF = "cmDisBGColorOff";
    private static final String DIS_TXTCOL = "cmDisTxtColor";
    private static final String DIS_HOVER = "cmDisHoverColor";

    public void init(PageContext context, MenuDisplayerMapping mapping) {
        super.init(context, mapping);
        try {
            this.out.print(SCRIPT_START);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        StringBuffer sb = new StringBuffer();
        this.buildMenuString(menu, sb, this.isAllowed(menu));
        this.out.print((Object)sb);
    }

    public void end(PageContext context) {
        try {
            this.out.print(END_STATEMENT);
            this.out.print(SCRIPT_END);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void buildMenuString(MenuComponent menu, StringBuffer sb, boolean allowed) {
        sb.append(menuMessage.format(this.getArgs(menu, allowed)));
        sb.append(allowed ? HOVER : DIS_HOVER);
        sb.append(",'");
        sb.append(menu.getOnclick() == null ? "" : menu.getOnclick());
        sb.append("')\n");
        MenuComponent[] subMenus = menu.getMenuComponents();
        if (subMenus.length > 0) {
            for (int i = 0; i < subMenus.length; ++i) {
                this.buildMenuString(subMenus[i], sb, allowed ? this.isAllowed(subMenus[i]) : allowed);
            }
        }
    }

    protected String[] getArgs(MenuComponent menu, boolean allowed) {
        String[] args = new String[]{menu.getName(), this.getParentName(menu), this.getTitle(menu), menu.getUrl() == null ? "" : (allowed ? menu.getUrl() : ""), this.getTarget(menu), "", "", allowed ? BGCOL_OFF : DIS_BGCOL_OFF, allowed ? BGCOL_ON : DIS_BGCOL_ON, allowed ? TXTCOL : DIS_TXTCOL};
        return args;
    }

    protected String getTitle(MenuComponent menu) {
        boolean hasSubMenus = false;
        String title = this.getMessage(menu.getTitle());
        if (menu.getMenuComponents().length > 0) {
            hasSubMenus = true;
            title = menu.getParent() == null ? title + "'+" + TOP_IMAGE + "+'" : title + "'+" + SUB_IMAGE + "+'";
        }
        return title;
    }

    protected String getParentName(MenuComponent menu) {
        String name = null;
        name = menu.getParent() == null ? "" : menu.getParent().getName();
        return name;
    }

    protected String getTarget(MenuComponent menu) {
        String theTarget = super.getTarget(menu);
        if (this.target == null) {
            theTarget = "";
        }
        return theTarget;
    }
}

