/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.LinkedList;
import org.springframework.aop.config.ConfigBeanDefinitionParser;
import org.springframework.aop.config.NamespaceHandlerUtils;
import org.springframework.aop.config.ScopeBeanDefinitionDefinition;
import org.springframework.aop.config.SpringConfiguredBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AopNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("config", new ConfigBeanDefinitionParser());
        this.registerBeanDefinitionParser("spring-configured", new SpringConfiguredBeanDefinitionParser());
        this.registerBeanDefinitionParser("aspectj-autoproxy", new AspectJAutoProxyBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("scope", new ScopeBeanDefinitionDefinition());
    }

    private static class AspectJAutoProxyBeanDefinitionParser
    implements BeanDefinitionParser {
        private AspectJAutoProxyBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            NamespaceHandlerUtils.registerAtAspectJAutoProxyCreatorIfNecessary(parserContext.getRegistry());
            if (element.hasChildNodes()) {
                this.addIncludePatterns(element, parserContext.getRegistry());
            }
            return null;
        }

        private void addIncludePatterns(Element element, BeanDefinitionRegistry registry) {
            BeanDefinition beanDef = registry.getBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
            LinkedList<String> includePatterns = new LinkedList<String>();
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                Element include = (Element)node;
                String patternText = include.getAttribute("name");
                includePatterns.add(patternText);
            }
            beanDef.getPropertyValues().addPropertyValue("includePatterns", includePatterns);
        }
    }
}

