/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MinimalMonitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorReportInterface;
import com.jamonapi.utils.Command;
import com.jamonapi.utils.Misc;
import com.jamonapi.utils.ResultSetUtils;
import java.util.ArrayList;
import java.util.Map;

public class MonitorConverter
implements MonitorReportInterface {
    private ResultSetUtils utils = ResultSetUtils.createInstance();
    private MonitorComposite rootComposite;
    private static String JAMON_ADMIN_PAGE_DEFAULT = "JAMonAdmin.jsp";
    String JAMonAdminPage = JAMON_ADMIN_PAGE_DEFAULT;
    private static String[][] EMPTY_ARRAY = new String[][]{{""}};
    private ArrayList rowsList = new ArrayList();
    private static int TYPICAL_NUM_CHILDREN = 30;

    protected MonitorConverter(MonitorComposite monitorComposite) {
        this.rootComposite = monitorComposite;
    }

    protected MonitorConverter(MonitorComposite monitorComposite, String string) {
        this.rootComposite = monitorComposite;
        this.JAMonAdminPage = string;
    }

    public String getReport(int n, String string) throws Exception {
        return new MonitorReport(n, string).getReport();
    }

    public String getReport() throws Exception {
        return this.getReport(1, "asc");
    }

    public String[][] getData() {
        return this.getData("");
    }

    public String[][] getData(String string) {
        this.getCompositeData(string, this.rootComposite);
        int n = this.rowsList.size();
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        return this.utils.arrayListToString(this.rowsList);
    }

    public Object[][] getData(String string, int n, String string2) {
        Object[][] objectArray = this.getData(string);
        if (objectArray == EMPTY_ARRAY) {
            return objectArray;
        }
        return Misc.sort(objectArray, n, string2);
    }

    protected void getData(String string, MinimalMonitor minimalMonitor) {
        if (minimalMonitor instanceof MonitorComposite) {
            this.getCompositeData(string, (MonitorComposite)minimalMonitor);
        } else {
            this.getLeafData(string, minimalMonitor);
        }
    }

    protected void getCompositeData(String string, MonitorComposite monitorComposite) {
        final class GetMonitorData
        implements Command {
            final /* synthetic */ MonitorConverter this$0;
            final /* synthetic */ String val$localLabel;
            final /* synthetic */ MonitorComposite val$composite;
            Map.Entry mapEntry;
            MinimalMonitor monitor;

            public void execute(Object object) throws Exception {
                String string = this.val$localLabel;
                this.mapEntry = (Map.Entry)object;
                this.monitor = (MinimalMonitor)this.mapEntry.getValue();
                String string2 = this.mapEntry.getKey().toString();
                string = String.valueOf(string) + this.val$composite.getLabelFromKey(string2);
                this.this$0.getData(string, this.monitor);
            }

            GetMonitorData(MonitorConverter monitorConverter, String string, MonitorComposite monitorComposite) {
                this.this$0 = monitorConverter;
                this.val$localLabel = string;
                this.val$composite = monitorComposite;
            }
        }
        monitorComposite.iterateMapEntries(new GetMonitorData(this, string, monitorComposite));
    }

    protected void getLeafData(String string, MinimalMonitor minimalMonitor) {
        ArrayList<String> arrayList = new ArrayList<String>(TYPICAL_NUM_CHILDREN);
        arrayList.add(string);
        minimalMonitor.getData(arrayList);
        String[] stringArray = new String[]{};
        this.rowsList.add(arrayList.toArray(stringArray));
    }

    protected static void setJAMonAdminPage(String string) {
        JAMON_ADMIN_PAGE_DEFAULT = string;
    }

    private final class MonitorReport {
        private final int sortCol;
        private final String sortOrder;
        private final StringBuffer table = new StringBuffer(20000);

        public MonitorReport(int n, String string) {
            this.sortCol = n;
            this.sortOrder = string;
        }

        public String getReport() throws Exception {
            this.addReportHeader();
            this.addReportBody();
            return this.table.toString();
        }

        private void addReportHeader() {
            this.table.append("<!-- Begin Report Sect. -->\n");
            this.table.append("<table border='0' cellpadding='0' cellspacing='0'>\n");
            this.table.append("<tr>\n");
            this.table.append("<td>\n");
            this.table.append("<table class='layoutmain' border='1' cellpadding='2' cellspacing='0' rules='all'>\n");
            this.table.append("<tr class='headtextr' valign='top'>\n");
            String[] stringArray = MonitorComposite.getHeader();
            int n = stringArray.length;
            String string = null;
            String string2 = null;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2 + 1;
                if (n3 == this.sortCol) {
                    String string3 = "asc".equalsIgnoreCase(this.sortOrder) ? "desc" : "asc";
                    string = "<th><a href='" + MonitorConverter.this.JAMonAdminPage + "?sortCol=" + n3 + "&sortOrder=" + string3 + "'>" + stringArray[n2] + "</a><br><img src='" + this.sortOrder + ".gif'></th>\n";
                } else {
                    string = "<th><a href='" + MonitorConverter.this.JAMonAdminPage + "?sortCol=" + n3 + "&sortOrder=desc'>" + stringArray[n2] + "</a><br></th>\n";
                }
                if (n2 == 0) {
                    string2 = string;
                }
                this.table.append(string);
                ++n2;
            }
            this.table.append(String.valueOf(string2) + "</tr>\n");
            this.table.append("<tr class='headtextr'>\n");
            this.table.append("<th colspan='13'>&nbsp;</th>\n");
            this.table.append("<th colspan='13'>Hits/Avg ms. &nbsp &nbsp &nbsp &nbsp &nbsp (Avg Active/Primary Active/Global Active)</th>\n");
            this.table.append("<th>&nbsp;</th>\n</tr>\n");
        }

        private void addReportBody() {
            Object[][] objectArray = MonitorConverter.this.getData("", this.sortCol - 1, this.sortOrder);
            int n = objectArray.length;
            int n2 = objectArray[0].length;
            int n3 = 0;
            while (n3 < n) {
                String string = n3 % 2 == 0 ? "odd" : "even";
                String string2 = objectArray[n3][0].toString();
                this.table.append("<tr class='" + string + "' onMouseOver='rollOnRow(this, \"Statistics for " + string2 + "\")' onMouseOut='rollOffRow(this)'>\n");
                String string3 = "<th class='headtextc' align='left' nowrap>" + string2 + "</th>\n";
                this.table.append(string3);
                int n4 = 1;
                while (n4 < n2) {
                    this.table.append("<td nowrap>" + objectArray[n3][n4] + "</td>\n");
                    ++n4;
                }
                this.table.append(string3);
                this.table.append("</tr>\n");
                ++n3;
            }
            this.table.append("</table>\n<!-- End Report Sect. -->\n");
        }
    }
}

