/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import java.util.ArrayList;

public class TimeStatsMonitor
extends AccumulateMonitor {
    private long min = Integer.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private int hits;
    private long total;
    private long sumOfSquares;

    public TimeStatsMonitor() {
    }

    public TimeStatsMonitor(AccumulateMonitorInterface accumulateMonitorInterface) {
        super(accumulateMonitorInterface);
    }

    protected synchronized void increaseThis(long l) {
        if (l < this.min) {
            this.min = l;
        }
        if (l > this.max) {
            this.max = l;
        }
        ++this.hits;
        this.total += l;
        this.sumOfSquares += l * l;
    }

    protected synchronized void resetThis() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.hits = 0;
        this.total = this.sumOfSquares = (long)0;
    }

    protected synchronized String toStringThis() {
        return String.valueOf(this.getDisplayString("Hits", AccumulateMonitor.convertToString(this.hits), "")) + this.getDisplayString("Avg", AccumulateMonitor.convertToString(this.avg()), "ms.") + this.getDisplayString("Total", AccumulateMonitor.convertToString(this.total), "ms.") + this.getDisplayString("Min", AccumulateMonitor.convertToString(this.min), "ms.") + this.getDisplayString("Max", AccumulateMonitor.convertToString(this.max), "ms.");
    }

    private long avg() {
        if (this.hits == 0) {
            return 0L;
        }
        return this.total / (long)this.hits;
    }

    private long stdDev() {
        long l = 0L;
        if (this.hits != 0) {
            long l2 = this.total;
            int n = this.hits;
            int n2 = n <= 1 ? 1 : n - 1;
            long l3 = this.sumOfSquares - l2 * l2 / (long)n;
            l = (long)Math.sqrt(l3 / (long)n2);
        }
        return l;
    }

    protected synchronized void getDataThis(ArrayList arrayList) {
        arrayList.add(AccumulateMonitor.convertToString(this.hits));
        arrayList.add(AccumulateMonitor.convertToString(this.avg()));
        arrayList.add(AccumulateMonitor.convertToString(this.total));
        arrayList.add(AccumulateMonitor.convertToString(this.stdDev()));
        arrayList.add(AccumulateMonitor.convertToString(this.min));
        arrayList.add(AccumulateMonitor.convertToString(this.max));
    }

    protected void getHeaderThis(ArrayList arrayList) {
        arrayList.add("Hits ");
        arrayList.add("Avg ms.");
        arrayList.add("Total ms.");
        arrayList.add("Std Dev ms.");
        arrayList.add("Min ms.");
        arrayList.add("Max ms.");
    }

    public synchronized long getAccrued() {
        return this.total;
    }

    public static void main(String[] stringArray) throws Exception {
        TimeStatsMonitor timeStatsMonitor = new TimeStatsMonitor();
        System.out.println("should not have 0 divide error=" + timeStatsMonitor);
        int n = 1;
        while (n < 5) {
            timeStatsMonitor.increase(n);
            ++n;
        }
        timeStatsMonitor.increase(100);
        System.out.println("toString()=" + timeStatsMonitor);
    }
}

