/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

public class MessageListenerAdapter102
extends MessageListenerAdapter {
    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter102());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Message response, Destination destination, Session session) throws JMSException {
        if (destination instanceof Topic) {
            TopicPublisher publisher = ((TopicSession)session).createPublisher((Topic)destination);
            try {
                this.postProcessProducer((MessageProducer)publisher, response);
                publisher.publish(response);
            }
            finally {
                JmsUtils.closeMessageProducer((MessageProducer)publisher);
            }
        }
        QueueSender sender = ((QueueSession)session).createSender((Queue)destination);
        try {
            this.postProcessProducer((MessageProducer)sender, response);
            sender.send(response);
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)sender);
        }
    }
}

