/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert;

import org.springframework.core.NestedRuntimeException;

public class ConversionException
extends NestedRuntimeException {
    private Object value;
    private Class targetClass;

    public ConversionException(Object value, Class targetClass) {
        super("Unable to convert value '" + value + "' of type '" + (value != null ? value.getClass().getName() : null) + "' to class '" + targetClass.getName() + "'");
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Object value, Class targetClass, Throwable cause) {
        super("Unable to convert value '" + value + "' of type '" + (value != null ? value.getClass().getName() : null) + "' to class '" + targetClass.getName() + "'", cause);
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Object value, Class targetClass, Throwable cause, String message) {
        super(message, cause);
        this.value = value;
        this.targetClass = targetClass;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }
}

